// modules/anna/assets/js/anna.js

var Anna = {
    init: function() {
        this.bindEvents();
    },

    bindEvents: function() {
        // Add quick chat functionality to any page
        if (typeof $ !== 'undefined') {
            this.addQuickChatButton();
        }
    },

    addQuickChatButton: function() {
        if ($('#quick-chat-btn').length === 0) {
            var button = `<div id="quick-chat-btn" style="position: fixed; bottom: 20px; right: 20px; z-index: 9999;">
                <button type="button" class="btn btn-primary btn-lg" onclick="Anna.showQuickChat()">
                    <i class="fa fa-comments"></i> AI
                </button>
            </div>`;
            $('body').append(button);
        }
    },

    showQuickChat: function() {
        var modal = `
        <div class="modal fade" id="quick-chat-modal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Quick AI Chat</h4>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div id="quick-chat-messages" style="height: 200px; overflow-y: auto; border: 1px solid #ddd; padding: 10px; margin-bottom: 10px;">
                        </div>
                        <div class="input-group">
                            <input type="text" class="form-control" id="quick-chat-input" placeholder="Ask me anything...">
                            <span class="input-group-btn">
                                <button class="btn btn-primary" type="button" onclick="Anna.sendQuickMessage()">
                                    <i class="fa fa-paper-plane"></i>
                                </button>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
        
        if ($('#quick-chat-modal').length === 0) {
            $('body').append(modal);
        }
        $('#quick-chat-modal').modal('show');
    },

    sendQuickMessage: function() {
        var input = $('#quick-chat-input');
        var message = input.val().trim();
        
        if (!message) return;
        
        this.addQuickMessage(message, 'user');
        input.val('');
        
        $.ajax({
            url: admin_url + 'anna/process_chat',
            type: 'POST',
            data: { 
                message: message,
                conversation_id: '',
                context: 'quick_chat',
                auth_key: app.anna.loggedUser.auth_key,
                key: app.anna.loggedUser.key
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Anna.addQuickMessage(response.response, 'ai');
                } else {
                    Anna.addQuickMessage('Error: ' + (response.error || 'Unknown error'), 'error');
                }
            },
            error: function() {
                Anna.addQuickMessage('Connection error', 'error');
            }
        });
    },

    addQuickMessage: function(message, type) {
        var messagesDiv = $('#quick-chat-messages');
        var messageClass = type === 'user' ? 'text-right' : (type === 'error' ? 'text-danger' : '');
        var prefix = type === 'user' ? 'You: ' : (type === 'error' ? 'Error: ' : 'AI: ');
        
        messagesDiv.append('<div class="' + messageClass + '"><strong>' + prefix + '</strong>' + message + '</div>');
        messagesDiv.scrollTop(messagesDiv[0].scrollHeight);
    }
};

// Initialize when document is ready
$(document).ready(function() {
    if (typeof admin_url !== 'undefined') {
        Anna.init();
    }
});
