<?php

defined('BASEPATH') or exit('No direct script access allowed');

/** @noinspection PhpIncludeInspection */
require __DIR__ . '/../REST_Controller.php';

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @package         CodeIgniter
 * @subpackage      Rest Server
 * @category        Controller
 * @author          Phil Sturgeon, Chris Kacerguis
 * @license         MIT
 * @link            https://github.com/chriskacerguis/codeigniter-restserver
 */
class Invoices extends REST_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('invoices_model');
        $this->load->model('clients_model');
    }

    public function data_get($id = '')
    {
        $key = $this->input->get('search');
        $data = $this->Api_model->search('invoices', $key);
        if ($data) {
            foreach ($data as $key => $value) {
                $data[$key]['invoice_number']          = format_invoice_number($value['id']);
                $value['allowed_payment_modes'] = $value['allowed_payment_modes'] !== null ? unserialize($value['allowed_payment_modes']) : [];
                $data[$key]['items']                    = get_items_by_type('invoice', $value['id']);
                $data[$key]['total_left_to_pay']     = get_invoice_total_left_to_pay($value['id'], $value['total']);
                $data[$key]['credits_applied']          = total_credits_applied_to_invoice($value['id']);

                $data[$key]['invoice_recurring_invoices'] = $this->invoices_model->get_invoice_recurring_invoices($value['id']);

                foreach ($data[$key]['invoice_recurring_invoices'] as $_key => $invoice) {
                    $data[$key]['invoice_recurring_invoices'][$_key]->invoice_number = format_invoice_number($invoice->id);
                }

                $data[$key]['applied_credits'] = $this->credit_notes_model->get_applied_invoice_credits($value['id']);

                foreach ($data[$key]['applied_credits'] as $_key => $credit) {
                    $data[$key]['applied_credits'][$_key]['credit_note_number'] = format_credit_note_number($credit['credit_id']);
                }
                $value['items'] = $data[$key]['items'];
                $items = get_items_table_data((object) $value, 'invoice', 'html', true);
                foreach ($data[$key]['items'] as $_key => $item) {

                    $item_taxes = $this->db
                        ->where('rel_type', 'invoice')
                        ->where('itemid', $item['id'])
                        ->get(db_prefix() . 'item_tax')
                        ->result_array();
                    $data[$key]['items'][$_key]['taxrate'] = [];
                    if (!empty($item_taxes)) {
                        foreach ($item_taxes as $item_tax) {
                            $data[$key]['items'][$_key]['taxrate'][] = [
                                'name' => $item_tax['taxname'],
                                'taxrate' => $item_tax['taxrate'],
                            ];
                        }
                    }
                }

                $data[$key]['taxes'] = $items->taxes();
                $data[$key]['client']                         = new stdClass();
                $data[$key]['client']->company                 = $value['company'];
                $data[$key]['client']->show_primary_contact = $value['show_primary_contact'];

                $data[$key]['format_organization_info'] = format_organization_info();
                $data[$key]['bill_to']             = format_customer_info((object) $data[$key], 'invoice', 'billing');
                if ($value['include_shipping'] == 1 && $value['show_shipping_on_invoice'] == 1) {
                    $data[$key]['ship_to']     = format_customer_info((object) $data[$key], 'invoice', 'shipping');
                }

                if (is_invoice_overdue((object) $data[$key])) {
                    $data[$key]['get_total_days_overdue'] = get_total_days_overdue($value['duedate']);
                }

                if ($value['recurring'] > 0 || $value['is_recurring_from'] != NULL) {

                    $recurring_invoice = (object) $value;
                    $show_recurring_invoice_info = true;

                    if ($value['is_recurring_from'] != NULL) {
                        $recurring_invoice = $this->invoices_model->get($value['is_recurring_from']);
                        // Maybe recurring invoice not longer recurring?
                        if ($recurring_invoice->recurring == 0) {
                            $show_recurring_invoice_info = false;
                        } else {
                            $next_recurring_date_compare = $recurring_invoice->last_recurring_date;
                        }
                    } else {
                        $next_recurring_date_compare = $recurring_invoice->date;
                        if ($recurring_invoice->last_recurring_date) {
                            $next_recurring_date_compare = $recurring_invoice->last_recurring_date;
                        }
                    }

                    if ($show_recurring_invoice_info) {
                        if ($recurring_invoice->custom_recurring == 0) {
                            $recurring_invoice->recurring_type = 'MONTH';
                        }
                        $data[$key]['next_date'] = date('Y-m-d', strtotime('+' . $recurring_invoice->recurring . ' ' . strtoupper($recurring_invoice->recurring_type), strtotime($next_recurring_date_compare)));
                    }

                    $data[$key]['show_recurring_invoice_info'] = $show_recurring_invoice_info;
                    $data[$key]['recurring_invoice'] = (array) $recurring_invoice;
                }
            }
            $data = $this->Api_model->get_api_custom_data($data, "invoice");

            $this->response($data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        }

        $this->response([
            'status' => FALSE,
            'message' => 'No data was found'
        ], REST_Controller::HTTP_OK);
    }

    public function data_post()
    {
        $_POST = json_decode($this->security->xss_clean(file_get_contents("php://input")), true);

        if (empty($_POST) || !isset($_POST)) {
            $message = array(
                'status' => FALSE,
                'message' => 'Data Not Acceptable OR Not Provided'
            );
            $this->response($message, REST_Controller::HTTP_OK);
        }

        $this->form_validation->set_data($_POST);
        $this->form_validation->set_rules('customer_id', 'Customer', 'trim|required|max_length[255]');
        $this->form_validation->set_rules('newitems[]', 'Items', 'required');

        // // $this->form_validation->set_rules('billing_street', 'Billing Street', 'trim|required|max_length[255]');

        if ($this->form_validation->run() == FALSE) {
            $message = array(
                'status' => FALSE,
                'error' => $this->form_validation->error_array(),
                'message' => validation_errors()
            );
            $this->response($message, REST_Controller::HTTP_OK);
        } else {

            $client = $this->clients_model->get($_POST['customer_id']);
            if (empty($client)) {
                $message = array(
                    'status' => FALSE,
                    'error' => 'customer_id',
                    'message' => 'Customer not exists [ID: ' . $_POST['customer_id'] . ']'
                );
                $this->response($message, REST_Controller::HTTP_OK);
            }

            // Initialize subtotal and total variables
            $subtotal = 0;
            foreach ($_POST['newitems'] as $key => $item) {
                $_POST['newitems'][$key]['long_description'] = '';
                $_POST['newitems'][$key]['order'] = $key;
                $_POST['newitems'][$key]['unit'] = '';

                $itemSubtotal = $item['qty'] * $item['rate'];
                $subtotal += $itemSubtotal;
            }

            $this->load->model('currencies_model');
            $base_currency     = $this->currencies_model->get_base_currency()->id;
            $currencyid = $this->clients_model->get_customer_default_currency($_POST['customer_id']);

            $invoice = [
                'clientid' => $_POST['customer_id'],
                'newitems' => $_POST['newitems'],
                'date' => _d(date('Y-m-d')),
                'duedate' => _d(date('Y-m-d', strtotime('+1 day'))),
                'subtotal' => $subtotal,
                'total' => $subtotal,
                'billing_street' => $client->billing_street,
                'number' => str_pad(get_option('next_invoice_number'), get_option('number_padding_prefixes'), '0', STR_PAD_LEFT),
                'currency' => ($currencyid == 0 ? $base_currency : $currencyid)
            ];

            $id = $this->invoices_model->add($invoice);
            if ($id > 0 && !empty($id)) {
                // success
                $message = array(
                    'status' => TRUE,
                    'message' => 'Invoice Added Successfully',
                    'insert_id' => $id
                );
                $this->response($message, REST_Controller::HTTP_OK);
            } else {
                // error
                $message = array(
                    'status' => FALSE,
                    'message' => 'Invoice Add Fail'
                );
                $this->response($message, REST_Controller::HTTP_OK);
            }
        }
    }
}
