<?php

defined('BASEPATH') or exit('No direct script access allowed');
require __DIR__ . '/../REST_Controller.php';
/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @package         CodeIgniter
 * @subpackage      Rest Server
 * @category        Controller
 */
class Leads extends REST_Controller
{

    function __construct()
    {
        // Construct the parent class
        parent::__construct();
        $this->load->model('Api_model');
        $this->load->model('Misc_model');
        $this->load->model('leads_model');
    }

    public function data_get()
    {
        $key = $this->input->get('search');

        $this->load->model('leads_model');
        $data = $this->Api_model->search('lead', $key);
        if ($data) {
            foreach ($data as $key => $value) {
                if (mb_strpos($value['name'], ' ') !== false) {
                    $_temp = explode(' ', $value['name']);
                    $data[$key]['firstname'] = $_temp[0];
                    if (isset($_temp[2])) {
                        $data[$key]['lastname'] = $_temp[1] . ' ' . $_temp[2];
                    } else {
                        $data[$key]['lastname'] = $_temp[1];
                    }
                } else {
                    $data[$key]['lastname'] = '';
                    $data[$key]['firstname'] = $value['name'];
                }

                $client = false;
                if (total_rows(db_prefix() . 'contacts', array('email' => $value['email'])) > 0 && total_rows(db_prefix() . 'clients', array('leadid' => $value['id'])) == 0) {
                } else if (total_rows(db_prefix() . 'clients', array('leadid' => $value['id']))) {
                    $client = true;
                }

                $data[$key]['lead_locked'] = false;
                if (total_rows(db_prefix() . 'clients', ['leadid' => $value['id']]) > 0) {
                    $data[$key]['lead_locked'] = ((!is_admin() && get_option('lead_lock_after_convert_to_customer') == 1) ? true : false);
                }

                $data[$key]['clientid'] = null;
                if ($client && (has_permission('customers', '', 'view') || is_customer_admin(get_client_id_by_lead_id($value['id'])))) {
                    $data[$key]['clientid'] = get_client_id_by_lead_id($value['id']);
                }

                $data[$key]['lead_to_customer'] = false;
                if (total_rows(db_prefix() . 'clients', array('leadid' => $value['id'])) == 0) {
                    $data[$key]['lead_to_customer'] = true;
                }

                $data[$key]['attachments'] = $this->leads_model->get_lead_attachments($value['id']);
            }

            $data = $this->Api_model->get_api_custom_data($data, "leads");

            $this->response($data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        } else {
            $this->response([
                'status' => FALSE,
                'message' => 'No data found'
            ], REST_Controller::HTTP_OK); // NOT_FOUND (404) being the HTTP response code
        }
    }


    public function data_post()
    {
       // form validation
        $this->form_validation->set_rules('name', 'Lead Name', 'trim|required|max_length[600]', array('is_unique' => 'This %s already exists please enter another Lead Name'));
        $this->form_validation->set_rules('source', 'Source', 'trim|required', array('is_unique' => 'This %s already exists please enter another Lead source'));
        $this->form_validation->set_rules('status', 'Status', 'trim|required', array('is_unique' => 'This %s already exists please enter another Status'));
        if ($this->form_validation->run() == FALSE) {
            // form validation error
            $message = array(
                'status' => FALSE,
                'error' => $this->form_validation->error_array(),
                'message' => validation_errors()
            );
            $this->response($message, REST_Controller::HTTP_OK);
        } else {
            $insert_data = [
                'name' => $this->input->post('name', TRUE),
                'source' => $this->input->post('source', TRUE),
                'status' => $this->input->post('status', TRUE),
                'assigned' => $this->Api_model->value($this->input->post('assigned', TRUE)),

                'tags' => $this->Api_model->value($this->input->post('tags', TRUE)),
                'title' => $this->Api_model->value($this->input->post('title', TRUE)),
                'email' => $this->Api_model->value($this->input->post('email', TRUE)),
                'website' => $this->Api_model->value($this->input->post('website', TRUE)),
                'phonenumber' => $this->Api_model->value($this->input->post('phonenumber', TRUE)),
                'company' => $this->Api_model->value($this->input->post('company', TRUE)),

                'address' => $this->Api_model->value($this->input->post('address', TRUE)),
                'city' => $this->Api_model->value($this->input->post('city', TRUE)),
                'state' => $this->Api_model->value($this->input->post('state', TRUE)),
                'zip' => $this->Api_model->value($this->input->post('zip', TRUE)),
                'country' => $this->Api_model->value($this->input->post('country', TRUE)),

                'lead_value' => $this->Api_model->value($this->input->post('lead_value', TRUE)),
                'default_language' => $this->Api_model->value($this->input->post('default_language', TRUE)),
                'description' => $this->Api_model->value($this->input->post('description', TRUE)),
                'custom_contact_date' => $this->Api_model->value($this->input->post('custom_contact_date', TRUE)),
                'is_public' => $this->Api_model->value($this->input->post('is_public', TRUE)),
                'contacted_today' => $this->Api_model->value($this->input->post('contacted_today', TRUE))
            ];

            if (!empty($this->input->post('custom_fields', TRUE))) {
                $insert_data['custom_fields'] = $this->Api_model->value($this->input->post('custom_fields', TRUE));
            }
            // insert data
            $this->load->model('leads_model');
            $output = $this->leads_model->add($insert_data);
            if ($output > 0 && !empty($output)) {
                // success
                $message = array(
                    'status' => TRUE,
                    'message' => 'Lead add successful.',
                    'insert_id' => $output
                );
                $this->response($message, REST_Controller::HTTP_OK);
            } else {
                // error
                $message = array(
                    'status' => FALSE,
                    'message' => 'Lead add fail.'
                );
                $this->response($message, REST_Controller::HTTP_OK);
            }
        }
    }

    public function data_delete($id = '')
    {
        $id = $this->security->xss_clean($id);
        if (empty($id) && !is_numeric($id)) {
            $message = array(
                'status' => FALSE,
                'message' => 'Invalid Lead ID'
            );
            $this->response($message, REST_Controller::HTTP_OK);
        } else {
            // delete data
            $this->load->model('leads_model');
            $output = $this->leads_model->delete($id);
            if ($output === TRUE) {
                // success
                $message = array(
                    'status' => TRUE,
                    'message' => 'Lead Delete Successful.'
                );
                $this->response($message, REST_Controller::HTTP_OK);
            } else {
                // error
                $message = array(
                    'status' => FALSE,
                    'message' => 'Lead Delete Fail.'
                );
                $this->response($message, REST_Controller::HTTP_OK);
            }
        }
    }

    public function data_put($id = '')
    {
        $_POST = json_decode($this->security->xss_clean(file_get_contents("php://input")), true);
        if (empty($_POST) || !isset($_POST)) {
            $message = array(
                'status' => FALSE,
                'message' => 'Data Not Acceptable OR Not Provided'
            );
            $this->response($message, REST_Controller::HTTP_OK);
        }
        $this->form_validation->set_data($_POST);

        if (empty($id) && !is_numeric($id)) {
            $message = array(
                'status' => FALSE,
                'message' => 'Invalid Lead ID'
            );
            $this->response($message, REST_Controller::HTTP_OK);
        } else {

            $update_data = $this->input->post();
            // update data
            $this->load->model('leads_model');
            $output = $this->leads_model->update($update_data, $id);
            if ($output > 0 && !empty($output)) {
                // success
                $message = array(
                    'status' => TRUE,
                    'message' => 'Lead Update Successful.'
                );
                $this->response($message, REST_Controller::HTTP_OK);
            } else {
                // error
                $message = array(
                    'status' => FALSE,
                    'message' => 'Lead Update Fail.'
                );
                $this->response($message, REST_Controller::HTTP_OK);
            }
        }
    }
}
