<?php defined('BASEPATH') or exit('No direct script access allowed');

/** @noinspection PhpIncludeInspection */
require __DIR__ . '/../REST_Controller.php';

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @package         CodeIgniter
 * @subpackage      Rest Server
 * @category        Controller
 * @author          Phil Sturgeon, Chris Kacerguis
 * @license         MIT
 * @link            https://github.com/chriskacerguis/codeigniter-restserver
 */

class Proposals extends REST_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('clients_model');
		$this->load->model('proposals_model');
	}

	public function data_get()
	{
		$key = $this->input->get('search');
		$data = $this->Api_model->search('proposals', $key);
		if ($data) {
			foreach ($data as $key => $value) {
				$data[$key]['proposal_number'] = format_proposal_number($value['id']);
				$data[$key]['formatted_total'] 	= app_format_money($value['total'], $value['name']);
				$data[$key]['formatted_date'] 	     = _d($value['date']);
				$data[$key]['formatted_open_till'] 	 = _d($value['open_till']);
				$data[$key]['attachments'] 	 = $this->proposals_model->get_attachments($value['id']);
				
				if($data[$key]['estimate_id'] != NULL){
					$data[$key]['formated_estimate_id'] = format_estimate_number($data[$key]['estimate_id']);
				}

				if($data[$key]['invoice_id'] != NULL) {
					$data[$key]['formated_invoice_id'] = format_invoice_number($data[$key]['invoice_id']);
				}

				if($value['rel_type'] == 'customer') {
					$data[$key]['client'] = get_client($value['rel_id']);
				}

				$data[$key]['items'] = get_items_by_type('proposal', $value['id']);
				foreach ($data[$key]['items'] as $_key => $item) {

					$item_taxes = $this->db
						->where('rel_type', 'proposal')
						->where('itemid', $item['id'])
						->get(db_prefix() . 'item_tax')
						->result_array();
					$data[$key]['items'][$_key]['taxrate'] = [];
					if (!empty($item_taxes)) {
						foreach ($item_taxes as $item_tax) {
							$data[$key]['items'][$_key]['taxrate'][] = [
								'name' => $item_tax['taxname'],
								'taxrate' => $item_tax['taxrate'],
							];
						}
					}
				}
			}

			$data = $this->Api_model->get_api_custom_data($data, "proposal");

			$this->response($data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
		} else {
			$this->response([
				'status' => FALSE,
				'message' => 'No data found'
			], REST_Controller::HTTP_OK); // NOT_FOUND (404) being the HTTP response code
		}
	}

	public function data_delete($id = '')
	{
		$id = $this->security->xss_clean($id);
		if (empty($id) && !is_numeric($id)) {
			$message = array(
				'status' => FALSE,
				'message' => 'Invalid Proposal ID'
			);
			$this->response($message, REST_Controller::HTTP_OK);
		} else {
			$is_exist = $this->proposals_model->get($id);
			if (is_object($is_exist)) {
				$output = $this->proposals_model->delete($id);
				if ($output === TRUE) {
					// success
					$message = array(
						'status' => TRUE,
						'message' => 'Proposal Deleted Successfully'
					);
					$this->response($message, REST_Controller::HTTP_OK);
				} else {
					// error
					$message = array(
						'status' => FALSE,
						'message' => 'Proposal Delete Fail'
					);
					$this->response($message, REST_Controller::HTTP_OK);
				}
			} else {
				$message = array(
					'status' => FALSE,
					'message' => 'Invalid Proposal ID'
				);
				$this->response($message, REST_Controller::HTTP_OK);
			}
		}
	}

	public function data_post()
	{
		$data = $this->input->post();

		$this->form_validation->set_rules('subject', 'Subject', 'trim|required|max_length[191]');
		$this->form_validation->set_rules('rel_type', 'Rel Type', 'trim|required|in_list[lead,customer]');
		$this->form_validation->set_rules('rel_id', 'Rel Id', 'trim|required|greater_than[0]');
		$this->form_validation->set_rules('proposal_to', 'Proposal to', 'trim|required|max_length[191]');
		$this->form_validation->set_rules('email', 'Email', 'trim|valid_email|required|max_length[150]');
		$this->form_validation->set_rules('newitems[]', 'Items', 'required');
		$this->form_validation->set_rules('currency', 'Currency', 'trim|required|max_length[255]');
		$this->form_validation->set_rules('date', 'date', 'trim|required|max_length[255]');
		$this->form_validation->set_rules('status', 'Status', 'trim|required|max_length[255]');
		$this->form_validation->set_rules('subtotal', 'Sub Total', 'trim|required|decimal|greater_than[0]');
		$this->form_validation->set_rules('total', 'Total', 'trim|required|decimal|greater_than[0]');
		$data['address'] = $data['address'] ?? "";

		if ($this->form_validation->run() == FALSE) {
			$message = array(
				'status' => FALSE,
				'error' => $this->form_validation->error_array(),
				'message' => validation_errors()
			);
			$this->response($message, REST_Controller::HTTP_OK);
		} else {
			$data['open_till'] = _d(date('Y-m-d', strtotime('+' . get_option('proposal_due_after') . ' DAY', strtotime(date('Y-m-d')))));

			$id = $this->proposals_model->add($data);
			if ($id > 0 && !empty($id)) {
				// success
				$message = array(
					'status' => TRUE,
					'message' => 'Proposal Added Successfully',
					'insert_id' => $id
				);
				$this->response($message, REST_Controller::HTTP_OK);
			} else {
				// error
				$message = array(
					'status' => FALSE,
					'message' => 'Proposal Add Fail'
				);
				$this->response($message, REST_Controller::HTTP_OK);
			}
		}
	}

	public function data_put($id = "")
	{
		$_POST = json_decode($this->security->xss_clean(file_get_contents("php://input")), true);

		if (empty($_POST) || !isset($_POST)) {
			$message = array(
				'status' => FALSE,
				'message' => 'Data Not Acceptable OR Not Provided'
			);
			$this->response($message, REST_Controller::HTTP_OK);
		}

		$this->form_validation->set_data($_POST);

		if (empty($id) && !is_numeric($id)) {
			$message = array(
				'status' => FALSE,
				'message' => 'Invalid Proposal ID'
			);
			$this->response($message, REST_Controller::HTTP_OK);
		} else {
			$this->form_validation->set_rules('subject', 'Subject', 'trim|required|max_length[191]');
			$this->form_validation->set_rules('rel_type', 'Rel Type', 'trim|required|in_list[lead,customer]');
			$this->form_validation->set_rules('rel_id', 'Rel Id', 'trim|required|greater_than[0]');
			$this->form_validation->set_rules('proposal_to', 'Proposal to', 'trim|required|max_length[191]');
			$this->form_validation->set_rules('email', 'Email', 'trim|valid_email|required|max_length[150]');
			$this->form_validation->set_rules('items[]', 'Items', 'required');
			$this->form_validation->set_rules('currency', 'Currency', 'trim|required|max_length[255]');
			$this->form_validation->set_rules('status', 'Status', 'trim|required|numeric|greater_than[0]');
			$this->form_validation->set_rules('date', 'date', 'trim|required|max_length[255]');
			$this->form_validation->set_rules('subtotal', 'Sub Total', 'trim|required|decimal|greater_than[0]');
			$this->form_validation->set_rules('total', 'Total', 'trim|required|decimal|greater_than[0]');
			$_POST['address'] = $_POST['address'] ?? "";

			if ($this->form_validation->run() == FALSE) {
				$message = array(
					'status' => FALSE,
					'error' => $this->form_validation->error_array(),
					'message' => validation_errors()
				);
				$this->response($message, REST_Controller::HTTP_OK);
			} else {
				$is_exist = $this->proposals_model->get($id);
				if (!is_object($is_exist)) {
					$message = array(
						'status' => FALSE,
						'message' => 'Proposal ID Doesn\'t Not Exist.'
					);
					$this->response($message, REST_Controller::HTTP_OK);
				}
				if (is_object($is_exist)) {
					$data = $this->input->post();
					$data['isedit'] = "";
					$success = $this->proposals_model->update($data, $id);
					if ($success == true) {
						$message = array(
							'status' => TRUE,
							'message' => "Proposal Updated Successfully",
						);
						$this->response($message, REST_Controller::HTTP_OK);
					} else {
						// error
						$message = array(
							'status' => FALSE,
							'message' => 'Proposal Update Fail'
						);
						$this->response($message, REST_Controller::HTTP_OK);
					}
				} else {
					$message = array(
						'status' => FALSE,
						'message' => 'Invalid Proposal ID'
					);
					$this->response($message, REST_Controller::HTTP_OK);
				}
			}
		}
	}

	public function validate_estimate_number($number, $estimateid)
	{
		$isedit = 'false';
		if (!empty($estimateid)) {
			$isedit = 'true';
		}
		$this->form_validation->set_message('validate_estimate_number', 'The {field} is already in use');
		$original_number = null;
		$date            = $this->input->post('date');
		if (!empty($estimateid)) {
			$data = $this->Api_model->get_table('estimates', $estimateid);
			$original_number = $data->number;
			if (empty($date)) {
				$date = $data->date;
			}
		}
		$number          = trim($number);
		$number          = ltrim($number, '0');

		if ($isedit == 'true') {
			if ($number == $original_number) {
				return TRUE;
			}
		}

		if (total_rows(db_prefix() . 'estimates', [
			'YEAR(date)' => date('Y', strtotime(to_sql_date($date))),
			'number' => $number,
		]) > 0) {
			return FALSE;
		} else {
			return TRUE;
		}
	}

	public function validate_invoice_number($number, $invoiceid)
	{
		$isedit = 'false';
		if (!empty($invoiceid)) {
			$isedit = 'true';
		}
		$this->form_validation->set_message('validate_invoice_number', 'The {field} is already in use');
		$original_number = null;
		$date            = $this->input->post('date');
		if (!empty($invoiceid)) {
			$data = $this->Api_model->get_table('invoices', $invoiceid);
			$original_number = $data->number;
			if (empty($date)) {
				$date = $data->date;
			}
		}
		$number          = trim($number);
		$number          = ltrim($number, '0');

		if ($isedit == 'true') {
			if ($number == $original_number) {
				return TRUE;
			}
		}

		if (total_rows(db_prefix() . 'invoices', [
			'YEAR(date)' => date('Y', strtotime(to_sql_date($date))),
			'number' => $number,
		]) > 0) {
			return FALSE;
		} else {
			return TRUE;
		}
	}
}
