<?php
// modules/anna/helpers/anna_helper.php
defined('BASEPATH') or exit('No direct script access allowed');

if (!function_exists('anna_get_chat_history')) {
    function anna_get_chat_history($staff_id = null, $limit = 10)
    {
        $CI = &get_instance();
        $CI->load->model('anna_model');
        return $CI->anna_model->get_chat_history($staff_id, $limit);
    }
}

if (!function_exists('anna_is_configured')) {
    function anna_is_configured()
    {
        $api_key = get_option('anna_openai_api_key');
        return !empty($api_key);
    }
}

if (!function_exists('anna_add_context')) {
    function anna_add_context($message, $context_type = 'general')
    {
        $CI = &get_instance();
        
        $context = '';
        switch ($context_type) {
            case 'customer':
                $context = 'Focus on customer management and support queries. ';
                break;
            case 'sales':
                $context = 'Focus on sales processes, leads, and opportunities. ';
                break;
            case 'project':
                $context = 'Focus on project management and task tracking. ';
                break;
            default:
                $context = 'General CRM assistance. ';
        }
        
        return $context . $message;
    }
}

if (!function_exists('anna_api_url')) {
    function anna_api_url()
    {
        $CI = &get_instance();
        $CI->load->config('anna/conf');
        return $CI->config->item('anna_api_url');
    }
}

if (!function_exists('anna_plans_api_url')) {
    function anna_plans_api_url()
    {
        $CI = &get_instance();
        $CI->load->config('anna/conf');
        return $CI->config->item('anna_plans_api_url');
    }
}
?>