<?php
// modules/anna/includes/hooks.php
defined('BASEPATH') or exit('No direct script access allowed');

// Add AI assistance to customer view
hooks()->add_action('after_customer_tabs_content', 'anna_customer_tab_content');

function anna_customer_tab_content($customer_id)
{
    if (!has_permission('anna', '', 'view')) {
        return;
    }
    
    echo '<div class="tab-pane" id="anna-tab">
        <div class="row">
            <div class="col-md-12">
                <h4>AI Customer Insights</h4>
                <div id="customer-ai-insights" data-customer-id="' . $customer_id . '">
                    <button type="button" class="btn btn-primary" onclick="getCustomerInsights(' . $customer_id . ')">
                        <i class="fa fa-magic"></i> Generate Customer Insights
                    </button>
                </div>
            </div>
        </div>
    </div>';
}

// Add AI tab to customer profile
hooks()->add_action('after_customer_tabs', 'anna_customer_tab');

function anna_customer_tab()
{
    if (!has_permission('anna', '', 'view')) {
        return;
    }
    
    echo '<li role="presentation">
        <a href="#anna-tab" aria-controls="anna-tab" role="tab" data-toggle="tab">
            <i class="fa fa-robot"></i> AI Insights
        </a>
    </li>';
}

// Add quick AI button to admin header
hooks()->add_action('app_admin_head', 'anna_admin_head');

function anna_admin_head()
{
    if (!has_permission('anna', '', 'view')) {
        return;
    }
    
    $CI = &get_instance();
    
    echo '<link rel="stylesheet" href="' . module_dir_url('anna', 'assets/css/anna.css') . '">';
    echo '<script>var admin_url = "' . admin_url() . '"; var csrf_token_name = "' . $CI->security->get_csrf_token_name() . '";</script>';
    echo '<script src="' . module_dir_url('anna', 'assets/js/conversation-manager.js') . '"></script>';
    echo '<script src="' . module_dir_url('anna', 'assets/js/anna-sync.js') . '"></script>';
    echo '<script src="' . module_dir_url('anna', 'assets/js/anna.js') . '"></script>';
}

// Add AI suggestions to lead conversion
hooks()->add_action('after_lead_converted_to_customer', 'anna_lead_conversion_suggestion');

function anna_lead_conversion_suggestion($data)
{
    if (!anna_is_configured()) {
        return;
    }
    
    $CI = &get_instance();
    $CI->load->model('anna_model');
    
    try {
        $message = "A lead has been converted to customer. Lead source: " . $data['source'] . 
                  ". Suggest 3 follow-up actions for the sales team.";
        
        $suggestion = $CI->anna_model->process_chat($message);
        
        // Log the suggestion for staff to see
        $CI->db->insert('anna_suggestions', [
            'type' => 'lead_conversion',
            'related_id' => $data['customer_id'],
            'suggestion' => $suggestion,
            'created_at' => date('Y-m-d H:i:s')
        ]);
        
    } catch (Exception $e) {
        log_message('error', 'Anna lead conversion suggestion failed: ' . $e->getMessage());
    }
}

?>