<?php
// modules/anna/views/chat.php
defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <!-- Modern Header -->
                        <div class="flex items-center justify-between mb-6">
                            <div class="flex items-center space-x-4">
                                <div class="w-12 h-12 bg-gradient-to-r from-blue-600 to-blue-700 rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h4 class="text-xl font-semibold text-gray-800 mb-1">Anna</h4>
                                    <div class="flex items-center space-x-2">
                                        <div class="w-2 h-2 bg-green-400 rounded-full animate-pulse"></div>
                                        <span class="text-sm text-gray-600">AI Assistant - Online</span>
                                    </div>
                                </div>
                            </div>
                            <div class="flex items-center space-x-3">
                                <button type="button" class="btn btn-default btn-sm" onclick="exportChat()">
                                    <i class="fa fa-download"></i> Export
                                </button>
                                <button type="button" class="btn btn-default btn-sm" onclick="clearChat()">
                                    <i class="fa fa-refresh"></i> Clear
                                </button>
                            </div>
                        </div>
                        
                        <!-- Modern Chat Container -->
                        <div class="bg-gray-50 rounded-lg border border-gray-200 mb-6" style="height: 600px; display: flex; flex-direction: column;">
                            <!-- Chat Messages -->
                            <div id="chat-messages" class="flex-1 p-6 overflow-y-auto space-y-4">
                                <!-- Welcome Message -->
                                <div class="flex items-start space-x-4">
                                    <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
                                        <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                    </div>
                                    <div class="bg-white rounded-lg rounded-tl-none p-4 shadow-sm max-w-2xl">
                                        <div class="text-gray-800">
                                            <p class="mb-2">👋 <strong>Hello ${getCurrentUserName()}!</strong></p>
                                            <p>I'm your AI assistant for Perfex CRM. I can help you with:</p>
                                            <div class="mt-3 space-y-2">
                                                <div class="flex items-center space-x-2">
                                                    <span class="text-blue-600">•</span>
                                                    <span>Finding customers and their information</span>
                                                </div>
                                                <div class="flex items-center space-x-2">
                                                    <span class="text-blue-600">•</span>
                                                    <span>Managing invoices and payments</span>
                                                </div>
                                                <div class="flex items-center space-x-2">
                                                    <span class="text-blue-600">•</span>
                                                    <span>Tracking leads and opportunities</span>
                                                </div>
                                                <div class="flex items-center space-x-2">
                                                    <span class="text-blue-600">•</span>
                                                    <span>Generating reports and analytics</span>
                                                </div>
                                            </div>
                                            <p class="mt-3 text-sm text-gray-600">How can I assist you today?</p>
                                        </div>
                                        <span class="text-xs text-gray-500 mt-2 block">${getCurrentTime()}</span>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Input Area -->
                            <div class="p-4 bg-white border-t border-gray-200 rounded-b-lg">
                                <div class="flex items-end space-x-4">
                                    <div class="flex-1">
                                        <textarea 
                                            class="w-full resize-none border border-gray-300 rounded-lg px-4 py-3 text-gray-800 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent" 
                                            id="chat-input" 
                                            rows="1" 
                                            placeholder="Type your message here..." 
                                            onkeypress="handleKeyPress(event)"
                                        ></textarea>
                                    </div>
                                    <button 
                                        type="button" 
                                        class="bg-blue-600 hover:bg-blue-700 text-white rounded-lg px-6 py-3 transition-colors duration-200 flex items-center space-x-2 font-medium" 
                                        onclick="sendMessage()" 
                                        id="send-btn"
                                    >
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                                        </svg>
                                        <span>Send</span>
                                    </button>
                                </div>
                                
                                <!-- Quick Actions -->
                                <div class="flex items-center justify-between mt-3">
                                    <div class="flex items-center space-x-4">
                                        <button onclick="insertQuickMessage('Search for a customer')" class="text-xs text-gray-500 hover:text-blue-600 transition-colors">
                                            🔍 Search Customer
                                        </button>
                                        <button onclick="insertQuickMessage('Show me recent invoices')" class="text-xs text-gray-500 hover:text-blue-600 transition-colors">
                                            📄 Recent Invoices
                                        </button>
                                        <button onclick="insertQuickMessage('Generate a sales report')" class="text-xs text-gray-500 hover:text-blue-600 transition-colors">
                                            📊 Sales Report
                                        </button>
                                    </div>
                                    <div class="text-xs text-gray-400">
                                        Press Enter to send • Shift+Enter for new line
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Modern Chat Styles */
#chat-messages::-webkit-scrollbar {
    width: 6px;
}

#chat-messages::-webkit-scrollbar-track {
    background: #f1f5f9;
    border-radius: 3px;
}

#chat-messages::-webkit-scrollbar-thumb {
    background: #cbd5e1;
    border-radius: 3px;
}

#chat-messages::-webkit-scrollbar-thumb:hover {
    background: #94a3b8;
}

/* Message animations */
.message-fade-in {
    animation: fadeInUp 0.4s ease-out;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(15px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Auto-resize textarea */
#chat-input {
    min-height: 44px;
    max-height: 120px;
    transition: all 0.2s ease;
}

/* Typing indicator */
.typing-indicator {
    display: flex;
    align-items: center;
    padding: 12px 16px;
    background: white;
    border-radius: 12px;
    border-top-left-radius: 4px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

.typing-dot {
    width: 8px;
    height: 8px;
    background-color: #cbd5e1;
    border-radius: 50%;
    animation: typing 1.4s infinite ease-in-out;
    margin-right: 4px;
}

.typing-dot:nth-child(1) { animation-delay: -0.32s; }
.typing-dot:nth-child(2) { animation-delay: -0.16s; }
.typing-dot:nth-child(3) { animation-delay: 0s; margin-right: 0; }

@keyframes typing {
    0%, 80%, 100% {
        opacity: 0.3;
        transform: scale(0.8);
    }
    40% {
        opacity: 1;
        transform: scale(1);
    }
}

/* Loading states */
.loading-btn {
    background: #9ca3af !important;
    cursor: not-allowed !important;
}

.loading-btn:hover {
    background: #9ca3af !important;
}

/* Message content formatting */
.message-content strong {
    font-weight: 600;
}

.message-content .bullet-point {
    display: flex;
    align-items: flex-start;
    margin: 8px 0;
}

.message-content .bullet-point .bullet {
    color: #3b82f6;
    margin-right: 8px;
    margin-top: 2px;
}

/* Code blocks */
.message-content code {
    background: #f3f4f6;
    padding: 2px 6px;
    border-radius: 4px;
    font-family: 'SF Mono', Monaco, 'Cascadia Code', 'Roboto Mono', Consolas, 'Courier New', monospace;
    font-size: 0.9em;
}

.message-content pre {
    background: #f3f4f6;
    padding: 12px;
    border-radius: 8px;
    overflow-x: auto;
    margin: 8px 0;
}

/* Responsive design */
@media (max-width: 768px) {
    .flex.items-center.space-x-4 {
        flex-direction: column;
        align-items: flex-start;
        space-x: 0;
    }
    
    .max-w-2xl {
        max-width: 90%;
    }
    
    .flex.items-center.space-x-4 > div {
        margin-bottom: 8px;
    }
}
</style>

<script>
// Modern Chat Functionality
let messageCount = 0;
let isTyping = false;

document.addEventListener('DOMContentLoaded', function() {
    initializeChat();
});

function initializeChat() {
    const input = document.getElementById('chat-input');
    
    // Auto-resize textarea
    input.addEventListener('input', function() {
        this.style.height = 'auto';
        this.style.height = Math.min(this.scrollHeight, 120) + 'px';
    });
    
    // Initialize welcome message
    const welcomeMessage = document.querySelector('#chat-messages .flex');
    if (welcomeMessage) {
        welcomeMessage.innerHTML = welcomeMessage.innerHTML
            .replace('${getCurrentUserName()}', '<?php echo get_staff_full_name(); ?>')
            .replace('${getCurrentTime()}', getCurrentTime());
    }
    
    input.focus();
}

function sendMessage() {
    const input = document.getElementById('chat-input');
    const message = input.value.trim();
    
    if (!message || isTyping) return;
    
    // Add user message
    addMessageToChat(message, 'user');
    
    // Clear input and show loading state
    input.value = '';
    input.style.height = 'auto';
    setLoadingState(true);
    showTypingIndicator();
    
    // Send to server
    $.ajax({
        url: '<?php echo admin_url('anna/chat'); ?>',
        type: 'POST',
        data: { message: message },
        dataType: 'json',
        success: function(response) {
            hideTypingIndicator();
            if (response.success) {
                addMessageToChat(response.response, 'ai');
            } else {
                addMessageToChat('I apologize, but I encountered an error. Please try again.', 'ai', true);
            }
        },
        error: function() {
            hideTypingIndicator();
            addMessageToChat('Unable to connect to the AI service. Please check your connection and try again.', 'ai', true);
        },
        complete: function() {
            setLoadingState(false);
            input.focus();
        }
    });
}

function addMessageToChat(message, type, isError = false) {
    const chatMessages = document.getElementById('chat-messages');
    const messageDiv = document.createElement('div');
    messageDiv.className = 'flex items-start space-x-4 message-fade-in';
    
    const currentTime = getCurrentTime();
    
    if (type === 'user') {
        messageDiv.innerHTML = `
            <div class="flex items-end space-x-4 justify-end w-full">
                <div class="bg-blue-600 text-white rounded-lg rounded-br-none p-4 shadow-sm max-w-2xl">
                    <div class="message-content">${escapeHtml(message)}</div>
                    <span class="text-xs text-blue-100 mt-2 block">${currentTime}</span>
                </div>
                <div class="w-10 h-10 bg-blue-600 rounded-full flex items-center justify-center flex-shrink-0 text-white font-semibold text-sm">
                    ${getCurrentUserInitials()}
                </div>
            </div>
        `;
        messageDiv.classList.add('justify-end');
    } else {
        const bgColor = isError ? 'bg-red-50 border border-red-200' : 'bg-white';
        const textColor = isError ? 'text-red-800' : 'text-gray-800';
        
        messageDiv.innerHTML = `
            <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
                <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
            <div class="${bgColor} rounded-lg rounded-tl-none p-4 shadow-sm max-w-2xl">
                <div class="message-content ${textColor}">${formatMessage(message)}</div>
                <span class="text-xs text-gray-500 mt-2 block">${currentTime}</span>
            </div>
        `;
    }
    
    chatMessages.appendChild(messageDiv);
    chatMessages.scrollTop = chatMessages.scrollHeight;
    messageCount++;
}

function showTypingIndicator() {
    const chatMessages = document.getElementById('chat-messages');
    const typingDiv = document.createElement('div');
    typingDiv.id = 'typing-indicator-container';
    typingDiv.className = 'flex items-start space-x-4';
    typingDiv.innerHTML = `
        <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
            <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
        </div>
        <div class="typing-indicator">
            <div class="typing-dot"></div>
            <div class="typing-dot"></div>
            <div class="typing-dot"></div>
        </div>
    `;
    chatMessages.appendChild(typingDiv);
    chatMessages.scrollTop = chatMessages.scrollHeight;
    isTyping = true;
}

function hideTypingIndicator() {
    const typingIndicator = document.getElementById('typing-indicator-container');
    if (typingIndicator) {
        typingIndicator.remove();
    }
    isTyping = false;
}

function setLoadingState(loading) {
    const sendBtn = document.getElementById('send-btn');
    const input = document.getElementById('chat-input');
    
    if (loading) {
        sendBtn.disabled = true;
        sendBtn.classList.add('loading-btn');
        sendBtn.innerHTML = `
            <svg class="w-4 h-4 animate-spin" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
            </svg>
            <span>Thinking...</span>
        `;
        input.disabled = true;
    } else {
        sendBtn.disabled = false;
        sendBtn.classList.remove('loading-btn');
        sendBtn.innerHTML = `
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
            </svg>
            <span>Send</span>
        `;
        input.disabled = false;
    }
}

function handleKeyPress(event) {
    if (event.key === 'Enter' && !event.shiftKey) {
        event.preventDefault();
        sendMessage();
    }
}

function insertQuickMessage(message) {
    const input = document.getElementById('chat-input');
    input.value = message;
    input.focus();
    input.style.height = 'auto';
    input.style.height = input.scrollHeight + 'px';
}

function clearChat() {
    const chatMessages = document.getElementById('chat-messages');
    chatMessages.innerHTML = `
        <div class="flex items-start space-x-4">
            <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
                <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
            <div class="bg-white rounded-lg rounded-tl-none p-4 shadow-sm max-w-2xl">
                <div class="text-gray-800">
                    <p>🔄 <strong>Chat cleared!</strong></p>
                    <p class="mt-2">How can I assist you today?</p>
                </div>
                <span class="text-xs text-gray-500 mt-2 block">${getCurrentTime()}</span>
            </div>
        </div>
    `;
    messageCount = 0;
}

function exportChat() {
    const messages = document.querySelectorAll('#chat-messages .message-content');
    let chatContent = 'Anna Chat Export\n';
    chatContent += '='.repeat(30) + '\n\n';
    
    messages.forEach((msg, index) => {
        const isUser = msg.closest('.justify-end') !== null;
        const sender = isUser ? 'You' : 'Anna';
        chatContent += `${sender}: ${msg.textContent}\n\n`;
    });
    
    const blob = new Blob([chatContent], { type: 'text/plain' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = `anna-chat-${new Date().toISOString().split('T')[0]}.txt`;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    URL.revokeObjectURL(url);
}

function getCurrentTime() {
    return new Date().toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
}

function getCurrentUserInitials() {
    return '<?php echo strtoupper(substr(get_staff_full_name(), 0, 1) . (strpos(get_staff_full_name(), " ") ? substr(get_staff_full_name(), strpos(get_staff_full_name(), " ") + 1, 1) : "")); ?>';
}

function escapeHtml(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

function formatMessage(message) {
    // Convert markdown-like formatting to HTML
    message = escapeHtml(message);
    
    // Bold text (**text**)
    message = message.replace(/\*\*(.*?)\*\*/g, '<strong>$1</strong>');
    
    // Bullet points (• text)
    message = message.replace(/^• (.+)$/gm, '<div class="bullet-point"><span class="bullet">•</span><span>$1</span></div>');
    
    // Line breaks
    message = message.replace(/\n/g, '<br>');
    
    // Code blocks (`code`)
    message = message.replace(/`([^`]+)`/g, '<code>$1</code>');
    
    return message;
}
</script>

<?php init_tail(); ?>
