<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">
                    <i class="fa fa-bug"></i> Error Monitoring & Debugging
                </h3>
            </div>
            <div class="panel-body">
                
                <!-- Configuration Section -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="panel panel-info">
                            <div class="panel-heading">
                                <h4 class="panel-title">Configuration</h4>
                            </div>
                            <div class="panel-body">
                                <?php echo form_open(admin_url('anna/update_error_settings')); ?>
                                
                                <div class="form-group">
                                    <label for="anna_debug_enabled">
                                        <input type="checkbox" 
                                               id="anna_debug_enabled" 
                                               name="anna_debug_enabled" 
                                               value="1" 
                                               <?php echo get_option('anna_debug_enabled') == '1' ? 'checked' : ''; ?>>
                                        Enable Debug Mode
                                    </label>
                                    <small class="help-block">Enable detailed debugging and performance monitoring</small>
                                </div>
                                
                                <div class="form-group">
                                    <label for="anna_performance_monitoring">
                                        <input type="checkbox" 
                                               id="anna_performance_monitoring" 
                                               name="anna_performance_monitoring" 
                                               value="1" 
                                               <?php echo get_option('anna_performance_monitoring') == '1' ? 'checked' : ''; ?>>
                                        Performance Monitoring
                                    </label>
                                    <small class="help-block">Monitor performance metrics and benchmarks</small>
                                </div>
                                
                                <div class="form-group">
                                    <label for="anna_save_debug_sessions">
                                        <input type="checkbox" 
                                               id="anna_save_debug_sessions" 
                                               name="anna_save_debug_sessions" 
                                               value="1" 
                                               <?php echo get_option('anna_save_debug_sessions') == '1' ? 'checked' : ''; ?>>
                                        Save Debug Sessions
                                    </label>
                                    <small class="help-block">Save debug sessions to database for analysis</small>
                                </div>
                                
                                <div class="form-group">
                                    <label for="anna_error_reporting_email">Error Reporting Email</label>
                                    <input type="email" 
                                           class="form-control" 
                                           id="anna_error_reporting_email" 
                                           name="anna_error_reporting_email" 
                                           value="<?php echo get_option('anna_error_reporting_email'); ?>" 
                                           placeholder="admin@example.com">
                                    <small class="help-block">Email address for critical error notifications</small>
                                </div>
                                
                                <div class="form-group">
                                    <label for="anna_log_retention_days">Log Retention (Days)</label>
                                    <input type="number" 
                                           class="form-control" 
                                           id="anna_log_retention_days" 
                                           name="anna_log_retention_days" 
                                           value="<?php echo get_option('anna_log_retention_days', '30'); ?>" 
                                           min="1" 
                                           max="365">
                                    <small class="help-block">How long to keep error logs (1-365 days)</small>
                                </div>
                                
                                <button type="submit" class="btn btn-primary">Save Configuration</button>
                                <?php echo form_close(); ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="panel panel-warning">
                            <div class="panel-heading">
                                <h4 class="panel-title">Error Statistics (24 Hours)</h4>
                            </div>
                            <div class="panel-body">
                                <div id="error-stats">
                                    <div class="text-center">
                                        <i class="fa fa-spinner fa-spin"></i> Loading statistics...
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Actions Section -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h4 class="panel-title">Actions</h4>
                            </div>
                            <div class="panel-body">
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-info" onclick="generateDebugReport()">
                                        <i class="fa fa-file-text"></i> Generate Debug Report
                                    </button>
                                    <button type="button" class="btn btn-warning" onclick="cleanupLogs()">
                                        <i class="fa fa-trash"></i> Cleanup Old Logs
                                    </button>
                                    <button type="button" class="btn btn-success" onclick="testErrorHandling()">
                                        <i class="fa fa-play"></i> Test Error Handling
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Recent Errors -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-danger">
                            <div class="panel-heading">
                                <h4 class="panel-title">Recent Errors</h4>
                            </div>
                            <div class="panel-body">
                                <div id="recent-errors">
                                    <div class="text-center">
                                        <i class="fa fa-spinner fa-spin"></i> Loading recent errors...
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    loadErrorStats();
    loadRecentErrors();
    
    // Auto-refresh every 30 seconds
    setInterval(function() {
        loadErrorStats();
        loadRecentErrors();
    }, 30000);
});

function loadErrorStats() {
    $.get('<?php echo admin_url('anna/get_error_stats'); ?>', function(data) {
        if (data.success) {
            var stats = data.stats;
            var html = '<div class="row">';
            html += '<div class="col-md-6 text-center">';
            html += '<h3 class="text-danger">' + stats.total_errors + '</h3>';
            html += '<p>Total Errors</p>';
            html += '</div>';
            html += '<div class="col-md-6">';
            html += '<h5>Breakdown:</h5>';
            html += '<ul class="list-unstyled">';
            
            if (stats.breakdown && stats.breakdown.length > 0) {
                stats.breakdown.forEach(function(item) {
                    html += '<li><strong>' + item.level + ' (' + item.category + '):</strong> ' + item.count + '</li>';
                });
            } else {
                html += '<li>No errors in the last 24 hours</li>';
            }
            
            html += '</ul>';
            html += '</div>';
            html += '</div>';
            html += '<small class="text-muted">Last updated: ' + stats.last_updated + '</small>';
            
            $('#error-stats').html(html);
        }
    }).fail(function() {
        $('#error-stats').html('<div class="alert alert-danger">Failed to load error statistics</div>');
    });
}

function loadRecentErrors() {
    $.get('<?php echo admin_url('anna/get_recent_errors'); ?>', function(data) {
        if (data.success) {
            var errors = data.errors;
            var html = '';
            
            if (errors.length > 0) {
                html += '<div class="table-responsive">';
                html += '<table class="table table-striped">';
                html += '<thead>';
                html += '<tr><th>Time</th><th>Level</th><th>Category</th><th>Message</th><th>Staff</th><th>Actions</th></tr>';
                html += '</thead>';
                html += '<tbody>';
                
                errors.forEach(function(error) {
                    html += '<tr>';
                    html += '<td>' + error.timestamp + '</td>';
                    html += '<td><span class="label label-' + getLevelClass(error.level) + '">' + error.level + '</span></td>';
                    html += '<td>' + error.category + '</td>';
                    html += '<td>' + (error.message.length > 50 ? error.message.substring(0, 50) + '...' : error.message) + '</td>';
                    html += '<td>' + (error.staff_id || 'System') + '</td>';
                    html += '<td><button class="btn btn-xs btn-info" onclick="showErrorDetails(\'' + error.error_id + '\')">Details</button></td>';
                    html += '</tr>';
                });
                
                html += '</tbody>';
                html += '</table>';
                html += '</div>';
            } else {
                html = '<div class="alert alert-success">No recent errors found</div>';
            }
            
            $('#recent-errors').html(html);
        }
    }).fail(function() {
        $('#recent-errors').html('<div class="alert alert-danger">Failed to load recent errors</div>');
    });
}

function getLevelClass(level) {
    switch(level) {
        case 'CRITICAL': return 'danger';
        case 'ERROR': return 'danger';
        case 'WARNING': return 'warning';
        case 'INFO': return 'info';
        case 'DEBUG': return 'default';
        default: return 'default';
    }
}

function generateDebugReport() {
    var btn = event.target;
    var originalText = btn.innerHTML;
    btn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Generating...';
    btn.disabled = true;
    
    window.open('<?php echo admin_url('anna/generate_debug_report'); ?>', '_blank');
    
    setTimeout(function() {
        btn.innerHTML = originalText;
        btn.disabled = false;
    }, 2000);
}

function cleanupLogs() {
    if (confirm('Are you sure you want to cleanup old logs? This action cannot be undone.')) {
        var btn = event.target;
        var originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Cleaning...';
        btn.disabled = true;
        
        $.post('<?php echo admin_url('anna/cleanup_logs'); ?>', function(data) {
            if (data.success) {
                alert('Cleaned up ' + data.deleted_count + ' old log entries');
                loadErrorStats();
                loadRecentErrors();
            } else {
                alert('Error cleaning up logs: ' + data.error);
            }
        }).fail(function() {
            alert('Failed to cleanup logs');
        }).always(function() {
            btn.innerHTML = originalText;
            btn.disabled = false;
        });
    }
}

function testErrorHandling() {
    var btn = event.target;
    var originalText = btn.innerHTML;
    btn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Testing...';
    btn.disabled = true;
    
    $.post('<?php echo admin_url('anna/test_error_handling'); ?>', function(data) {
        if (data.success) {
            alert('Error handling test completed. Check the recent errors section.');
            loadRecentErrors();
        } else {
            alert('Error handling test failed: ' + data.error);
        }
    }).fail(function() {
        alert('Failed to run error handling test');
    }).always(function() {
        btn.innerHTML = originalText;
        btn.disabled = false;
    });
}

function showErrorDetails(errorId) {
    $.get('<?php echo admin_url('anna/get_error_details'); ?>/' + errorId, function(data) {
        if (data.success) {
            var error = data.error;
            var modal = '<div class="modal fade" id="errorModal" tabindex="-1" role="dialog">';
            modal += '<div class="modal-dialog modal-lg" role="document">';
            modal += '<div class="modal-content">';
            modal += '<div class="modal-header">';
            modal += '<h4 class="modal-title">Error Details - ' + error.error_id + '</h4>';
            modal += '<button type="button" class="close" data-dismiss="modal">&times;</button>';
            modal += '</div>';
            modal += '<div class="modal-body">';
            modal += '<div class="row">';
            modal += '<div class="col-md-6"><strong>Timestamp:</strong> ' + error.timestamp + '</div>';
            modal += '<div class="col-md-6"><strong>Level:</strong> <span class="label label-' + getLevelClass(error.level) + '">' + error.level + '</span></div>';
            modal += '</div><br>';
            modal += '<div class="row">';
            modal += '<div class="col-md-6"><strong>Category:</strong> ' + error.category + '</div>';
            modal += '<div class="col-md-6"><strong>Staff ID:</strong> ' + (error.staff_id || 'System') + '</div>';
            modal += '</div><br>';
            modal += '<div class="row">';
            modal += '<div class="col-md-12"><strong>Message:</strong><br>' + error.message + '</div>';
            modal += '</div><br>';
            if (error.context) {
                modal += '<div class="row">';
                modal += '<div class="col-md-12"><strong>Context:</strong><br><pre>' + JSON.stringify(JSON.parse(error.context), null, 2) + '</pre></div>';
                modal += '</div>';
            }
            if (error.stack_trace) {
                modal += '<div class="row">';
                modal += '<div class="col-md-12"><strong>Stack Trace:</strong><br><pre>' + error.stack_trace + '</pre></div>';
                modal += '</div>';
            }
            modal += '</div>';
            modal += '<div class="modal-footer">';
            modal += '<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>';
            modal += '</div>';
            modal += '</div>';
            modal += '</div>';
            modal += '</div>';
            
            $('body').append(modal);
            $('#errorModal').modal('show');
            $('#errorModal').on('hidden.bs.modal', function () {
                $('#errorModal').remove();
            });
        }
    });
}
</script>