<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="anna-settings">
    <!-- Header Section -->
    <div class="settings-header">
        <div class="header-content">
            <div class="header-info">
                <h1>Anna</h1>
                <p>Manage your AI-powered CRM assistant subscription</p>
            </div>
            <div class="header-status" id="header-status">
                <div class="status-loading">
                    <div class="loading-spinner"></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Subscription Overview Card -->
    <div class="subscription-overview" id="subscription-overview">
        <div class="overview-loading">
            <div class="loading-spinner"></div>
            <p>Loading subscription details...</p>
        </div>
    </div>

    <!-- Plans Section -->
    <div class="plans-section">
        <div class="section-header">
            <h2>Choose Your Plan</h2>
            <p>Select the perfect plan for your business needs</p>
        </div>

        <div id="plans-container">
            <div class="plans-loading">
                <div class="loading-spinner"></div>
                <p>Loading available plans...</p>
            </div>
        </div>
    </div>

    <!-- Billing Management Section -->
    <div class="billing-section" id="billing-section" style="display: none;">
        <div class="billing-card">
            <div class="billing-header">
                <div class="billing-icon">
                    <i class="fa fa-credit-card"></i>
                </div>
                <div class="billing-info">
                    <h3>Billing Management</h3>
                    <p>Manage your payment methods, billing history, and subscription settings</p>
                </div>
            </div>
            <div class="billing-actions">
                <button class="btn-portal" onclick="openBillingPortal()">
                    <i class="fa fa-external-link"></i>
                    Open Billing Portal
                </button>
            </div>
        </div>
    </div>
</div>

<style>
    .anna-settings {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
    }

    /* Header Section */
    .settings-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 24px;
        padding: 40px;
        margin-bottom: 32px;
        color: white;
        position: relative;
        overflow: hidden;
    }

    .settings-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.05"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        pointer-events: none;
    }

    .header-content {
        display: flex;
        justify-content: space-between;
        align-items: center;
        position: relative;
        z-index: 1;
    }

    .header-info h1 {
        font-size: 32px;
        font-weight: 700;
        margin: 0 0 8px 0;
        letter-spacing: -0.5px;
    }

    .header-info p {
        font-size: 16px;
        opacity: 0.9;
        margin: 0;
        font-weight: 400;
    }

    .header-status {
        text-align: right;
    }

    .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        background: rgba(255, 255, 255, 0.2);
        backdrop-filter: blur(10px);
        padding: 12px 20px;
        border-radius: 50px;
        border: 1px solid rgba(255, 255, 255, 0.3);
        font-weight: 500;
    }

    .status-badge.active {
        background: rgba(34, 197, 94, 0.2);
        border-color: rgba(34, 197, 94, 0.3);
    }

    .status-badge.inactive {
        background: rgba(239, 68, 68, 0.2);
        border-color: rgba(239, 68, 68, 0.3);
    }

    /* Subscription Overview */
    .subscription-overview {
        background: white;
        border-radius: 20px;
        padding: 32px;
        margin-bottom: 32px;
        box-shadow: 0 4px 25px rgba(0, 0, 0, 0.08);
        border: 1px solid rgba(0, 0, 0, 0.06);
    }

    .overview-grid {
        display: grid;
        grid-template-columns: 1fr auto;
        gap: 32px;
        align-items: center;
    }

    .overview-details h2 {
        font-size: 24px;
        font-weight: 700;
        color: #1f2937;
        margin: 0 0 8px 0;
        letter-spacing: -0.3px;
    }

    .overview-details p {
        color: #6b7280;
        margin: 0 0 20px 0;
        font-size: 15px;
        line-height: 1.5;
    }

    .overview-meta {
        display: flex;
        gap: 24px;
        margin-top: 16px;
    }

    .meta-item {
        display: flex;
        flex-direction: column;
        gap: 4px;
    }

    .meta-label {
        font-size: 12px;
        font-weight: 500;
        color: #9ca3af;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .meta-value {
        font-size: 14px;
        font-weight: 600;
        color: #374151;
    }

    .overview-pricing {
        text-align: right;
    }

    .price-display {
        font-size: 48px;
        font-weight: 800;
        color: #111827;
        line-height: 1;
        letter-spacing: -1px;
        margin: 0;
    }

    .price-display .currency {
        font-size: 24px;
        color: #6b7280;
        vertical-align: top;
    }

    .price-period {
        color: #9ca3af;
        font-size: 16px;
        font-weight: 500;
        margin-top: 4px;
    }

    .plan-status {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 8px 16px;
        border-radius: 50px;
        font-size: 13px;
        font-weight: 500;
        margin-top: 16px;
    }

    .plan-status.active {
        background: rgba(34, 197, 94, 0.1);
        color: #15803d;
    }

    .plan-status.canceled {
        background: rgba(249, 115, 22, 0.1);
        color: #ea580c;
    }

    .plan-status.inactive {
        background: rgba(239, 68, 68, 0.1);
        color: #dc2626;
    }

    /* Loading States */
    .overview-loading,
    .plans-loading,
    .status-loading {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        padding: 40px;
        color: #9ca3af;
    }

    .status-loading {
        padding: 20px;
    }

    .loading-spinner {
        width: 24px;
        height: 24px;
        border: 2px solid #f3f4f6;
        border-top: 2px solid #6366f1;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin-bottom: 12px;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Plans Section */
    .plans-section {
        margin-bottom: 32px;
    }

    .section-header {
        text-align: center;
        margin-bottom: 32px;
    }

    .section-header h2 {
        font-size: 28px;
        font-weight: 700;
        color: #111827;
        margin: 0 0 8px 0;
        letter-spacing: -0.4px;
    }

    .section-header p {
        color: #6b7280;
        font-size: 16px;
        margin: 0;
    }

    .plans-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
        gap: 24px;
        margin-top: 32px;
    }

    /* Plan Cards */
    .plan-card {
        background: white;
        border: 2px solid #f3f4f6;
        border-radius: 20px;
        padding: 32px;
        position: relative;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        height: fit-content;
    }

    .plan-card:hover {
        border-color: #6366f1;
        transform: translateY(-4px);
        box-shadow: 0 20px 40px rgba(99, 102, 241, 0.15);
    }

    .plan-card.current {
        border-color: #22c55e;
        background: linear-gradient(135deg, rgba(34, 197, 94, 0.02), rgba(34, 197, 94, 0.05));
    }

    .plan-card.popular {
        border-color: #6366f1;
        background: linear-gradient(135deg, rgba(99, 102, 241, 0.02), rgba(99, 102, 241, 0.05));
        transform: scale(1.02);
    }

    .plan-badge {
        position: absolute;
        top: -12px;
        left: 50%;
        transform: translateX(-50%);
        background: linear-gradient(135deg, #6366f1, #4f46e5);
        color: white;
        padding: 8px 20px;
        border-radius: 50px;
        font-size: 12px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        box-shadow: 0 4px 20px rgba(99, 102, 241, 0.4);
    }

    .plan-badge.current {
        background: linear-gradient(135deg, #22c55e, #16a34a);
        box-shadow: 0 4px 20px rgba(34, 197, 94, 0.4);
    }

    .plan-header {
        text-align: center;
        margin-bottom: 24px;
    }

    .plan-name {
        font-size: 24px;
        font-weight: 700;
        color: #111827;
        margin: 0 0 8px 0;
        text-transform: capitalize;
    }

    .plan-description {
        color: #6b7280;
        font-size: 14px;
        margin: 0;
    }

    .plan-pricing {
        text-align: center;
        margin: 24px 0;
    }

    .plan-price {
        font-size: 42px;
        font-weight: 800;
        color: #111827;
        line-height: 1;
        margin: 0;
    }

    .plan-price .currency {
        font-size: 20px;
        color: #6b7280;
        vertical-align: top;
    }

    .plan-period {
        color: #9ca3af;
        font-size: 14px;
        margin-top: 4px;
    }

    .plan-features {
        list-style: none;
        padding: 0;
        margin: 24px 0;
    }

    .plan-features li {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 8px 0;
        color: #374151;
        font-size: 14px;
    }

    .plan-features li i {
        color: #22c55e;
        font-size: 16px;
        width: 16px;
        text-align: center;
    }

    .plan-button {
        width: 100%;
        padding: 16px 24px;
        border: none;
        border-radius: 12px;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s ease;
        position: relative;
        overflow: hidden;
    }

    .plan-button.primary {
        background: linear-gradient(135deg, #6366f1, #4f46e5);
        color: white;
        box-shadow: 0 4px 20px rgba(99, 102, 241, 0.3);
    }

    .plan-button.primary:hover {
        background: linear-gradient(135deg, #4f46e5, #4338ca);
        transform: translateY(-1px);
        box-shadow: 0 6px 25px rgba(99, 102, 241, 0.4);
    }

    .plan-button.secondary {
        background: #f8fafc;
        color: #374151;
        border: 2px solid #e5e7eb;
    }

    .plan-button.secondary:hover {
        background: #f1f5f9;
        border-color: #d1d5db;
    }

    .plan-button.current {
        background: #f0fdf4;
        color: #15803d;
        border: 2px solid #bbf7d0;
        cursor: not-allowed;
    }

    /* Billing Section */
    .billing-section {
        margin-top: 32px;
    }

    .billing-card {
        background: white;
        border-radius: 20px;
        padding: 32px;
        box-shadow: 0 4px 25px rgba(0, 0, 0, 0.08);
        border: 1px solid rgba(0, 0, 0, 0.06);
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 24px;
    }

    .billing-header {
        display: flex;
        align-items: center;
        gap: 16px;
    }

    .billing-icon {
        width: 48px;
        height: 48px;
        background: linear-gradient(135deg, #f59e0b, #d97706);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 20px;
    }

    .billing-info h3 {
        font-size: 18px;
        font-weight: 600;
        color: #111827;
        margin: 0 0 4px 0;
    }

    .billing-info p {
        color: #6b7280;
        font-size: 14px;
        margin: 0;
    }

    .btn-portal {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
        border: none;
        padding: 12px 24px;
        border-radius: 12px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s ease;
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 14px;
    }

    .btn-portal:hover {
        background: linear-gradient(135deg, #4b5563, #374151);
        transform: translateY(-1px);
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .anna-settings {
            padding: 0 16px;
        }

        .settings-header {
            padding: 24px;
            text-align: center;
        }

        .header-content {
            flex-direction: column;
            gap: 16px;
        }

        .header-info h1 {
            font-size: 24px;
        }

        .subscription-overview {
            padding: 24px;
        }

        .overview-grid {
            grid-template-columns: 1fr;
            gap: 24px;
            text-align: center;
        }

        .overview-meta {
            justify-content: center;
            gap: 16px;
        }

        .plans-grid {
            grid-template-columns: 1fr;
            gap: 20px;
        }

        .plan-card.popular {
            transform: none;
        }

        .billing-card {
            flex-direction: column;
            text-align: center;
        }

        .billing-header {
            flex-direction: column;
            text-align: center;
        }
    }

    /* Dark mode support */
    @media (prefers-color-scheme: dark) {
        .anna-settings {
            color: #f9fafb;
        }

        .subscription-overview,
        .plan-card,
        .billing-card {
            background: #1f2937;
            border-color: #374151;
        }

        .overview-details h2,
        .plan-name,
        .billing-info h3 {
            color: #f9fafb;
        }
    }
</style>

<script>
    // Global variables
    let currentPlan = null;
    let availablePlans = [];
    let subscriptionData = null;

    // Load plans on page load
    document.addEventListener('DOMContentLoaded', function() {
        loadPlans();
    });

    // Load plans from API
    function loadPlans() {
        const apiUrl = '<?php echo admin_url('anna/get_plans'); ?>';
        
        let formData = new FormData();
        formData.append('csrf_token_name', $('input[name=csrf_token_name]').val());
        formData.append('token', app.anna.loggedUser.token);
        formData.append('site_url', site_url);

        fetch(apiUrl, {
            method: 'POST',
            body: formData
        })
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            console.log('Plans API Response:', data);
            
            if (data.plans && Array.isArray(data.plans)) {
                availablePlans = data.plans;
                subscriptionData = data;
                
                updateHeaderStatus(data);
                updateSubscriptionOverview(data);
                updatePlansGrid(data);
                updateBillingSection(data);
            } else {
                showError('Invalid API response format');
            }
        })
        .catch(error => {
            console.error('Error loading plans:', error);
            showError('Failed to load plans. Please try again later.');
        });
    }

    // Update header status
    function updateHeaderStatus(data) {
        const headerStatus = document.getElementById('header-status');
        
        if (data.has_active_subscription) {
            const status = data.subscription_info.status;
            const isCanceled = data.subscription_info.cancel_at_period_end;
            
            let statusClass = 'active';
            let statusText = 'Active';
            let statusIcon = 'fa-check-circle';
            
            if (isCanceled) {
                statusClass = 'inactive';
                statusText = 'Canceling';
                statusIcon = 'fa-exclamation-triangle';
            } else if (status !== 'active') {
                statusClass = 'inactive';
                statusText = status.charAt(0).toUpperCase() + status.slice(1);
                statusIcon = 'fa-times-circle';
            }
            
            headerStatus.innerHTML = `
                <div class="status-badge ${statusClass}">
                    <i class="fa ${statusIcon}"></i>
                    ${statusText}
                </div>
            `;
        } else {
            headerStatus.innerHTML = `
                <div class="status-badge inactive">
                    <i class="fa fa-check-circle"></i>
                    Freemium Plan
                </div>
            `;
        }
    }

    // Update subscription overview
    function updateSubscriptionOverview(data) {
        const overviewContainer = document.getElementById('subscription-overview');
        
        if (!data.has_active_subscription) {
            // Find freemium plan in available plans
            const freemiumPlan = availablePlans.find(plan => plan.name.toLowerCase() === 'freemium' && plan.amount === 0);
            
            if (freemiumPlan) {
                // Show freemium as current active plan
                overviewContainer.innerHTML = `
                    <div class="overview-grid">
                        <div class="overview-details">
                            <h2>Freemium Plan</h2>
                            <p>${getDescriptionByPlan('freemium')}</p>
                            <div class="plan-status active">
                                <i class="fa fa-check-circle"></i>
                                Active (Free Plan)
                            </div>
                            <div class="overview-meta">
                                <div class="meta-item">
                                    <div class="meta-label">Plan Type</div>
                                    <div class="meta-value">Free Forever</div>
                                </div>
                            </div>
                        </div>
                        <div class="overview-pricing">
                            <div class="price-display">
                                <span class="currency">$</span>0
                            </div>
                            <div class="price-period">per month</div>
                        </div>
                    </div>
                `;
            } else {
                // Fallback if freemium plan not found
                overviewContainer.innerHTML = `
                    <div class="overview-grid">
                        <div class="overview-details">
                            <h2>Welcome to Anna</h2>
                            <p>Get started with AI-powered CRM assistance. Choose a plan below to unlock powerful features that will transform how you manage your business.</p>
                            <div class="plan-status inactive">
                                <i class="fa fa-info-circle"></i>
                                No active subscription
                            </div>
                        </div>
                        <div class="overview-pricing">
                            <div class="price-display">
                                <span class="currency">$</span>0
                            </div>
                            <div class="price-period">Free trial</div>
                        </div>
                    </div>
                `;
            }
            return;
        }

        const subscription = data.subscription_info;
        const currentActivePlan = availablePlans.find(plan => plan.active) || availablePlans[0];
        
        if (!currentActivePlan) return;

        const price = formatPrice(currentActivePlan.amount, currentActivePlan.currency);
        const nextBilling = subscription.current_period_end ? 
            new Date(subscription.current_period_end).toLocaleDateString() : 'N/A';
        
        const isActive = subscription.status === 'active';
        const isCanceled = subscription.cancel_at_period_end;
        
        let statusClass = 'active';
        let statusText = 'Active';
        let statusIcon = 'fa-check-circle';
        
        if (isCanceled) {
            statusClass = 'canceled';
            statusText = `Cancels on ${nextBilling}`;
            statusIcon = 'fa-exclamation-triangle';
        } else if (!isActive) {
            statusClass = 'inactive';
            statusText = subscription.status.charAt(0).toUpperCase() + subscription.status.slice(1);
            statusIcon = 'fa-times-circle';
        }

        overviewContainer.innerHTML = `
            <div class="overview-grid">
                <div class="overview-details">
                    <h2>${currentActivePlan.name.charAt(0).toUpperCase() + currentActivePlan.name.slice(1)} Plan</h2>
                    <p>${getDescriptionByPlan(currentActivePlan.name)}</p>
                    
                    <div class="plan-status ${statusClass}">
                        <i class="fa ${statusIcon}"></i>
                        ${statusText}
                    </div>
                    
                    <div class="overview-meta">
                        <div class="meta-item">
                            <div class="meta-label">Next Billing</div>
                            <div class="meta-value">${nextBilling}</div>
                        </div>
                    </div>
                </div>
                <div class="overview-pricing">
                    <div class="price-display">
                        <span class="currency">$</span>${price}
                    </div>
                    <div class="price-period">per month</div>
                </div>
            </div>
        `;
    }

    // Update plans grid
    function updatePlansGrid(data) {
        const plansContainer = document.getElementById('plans-container');
        
        if (!availablePlans.length) {
            showError('No plans available');
            return;
        }

        let plansHtml = '<div class="plans-grid">';
        
        availablePlans.forEach((plan, index) => {
            if (!plan.active) return;

            const price = formatPrice(plan.amount, plan.currency);
            const isFreemium = plan.name.toLowerCase() === 'freemium' && plan.amount === 0;
            
            // Determine if this plan is current
            let isCurrent = false;
            if (data.has_active_subscription) {
                // If user has active subscription, check if this plan matches their subscription
                isCurrent = availablePlans.find(p => p.active && p.name.toLowerCase() === plan.name.toLowerCase());
            } else {
                // If no active subscription, freemium is considered current
                isCurrent = isFreemium;
            }
            
            const isPopular = plan.name.toLowerCase() === 'pro';

            let cardClass = 'plan-card';
            if (isCurrent) cardClass += ' current';
            if (isPopular) cardClass += ' popular';

            let badge = '';
            if (isCurrent) {
                badge = '<div class="plan-badge current">Current Plan</div>';
            } else if (isPopular) {
                badge = '<div class="plan-badge">Most Popular</div>';
            }

            const featuresHtml = plan.features.map(feature => 
                `<li><i class="fa fa-check"></i> ${feature}</li>`
            ).join('');

            let buttonClass = 'plan-button';
            let buttonText = '';
            let buttonAction = '';

            if (isCurrent) {
                buttonClass += ' current';
                buttonText = '<i class="fa fa-check"></i> Current Plan';
                buttonAction = 'disabled';
            } else {
                buttonClass += isPopular ? ' primary' : ' secondary';
                
                if (isFreemium) {
                    // Special handling for freemium plan
                    buttonText = '<i class="fa fa-gift"></i> Activate Free Plan';
                    if (plan.checkout_url) {
                        buttonAction = `onclick="activateFreemiumPlan('${plan.checkout_url}')"`;
                    } else {
                        buttonAction = `onclick="activateFreemiumPlan(null)"`;
                    }
                } else {
                    buttonText = data.has_active_subscription ? 
                        '<i class="fa fa-arrow-up"></i> Switch Plan' : 
                        '<i class="fa fa-crown"></i> Select Plan';

                    if (plan.checkout_url) {
                        buttonAction = `onclick="redirectToCheckout('${plan.checkout_url}')"`;
                    } else {
                        buttonAction = `onclick="upgradePlan('${plan.id}', '${plan.name}')"`;
                    }
                }
            }

            plansHtml += `
                <div class="${cardClass}">
                    ${badge}
                    <div class="plan-header">
                        <div class="plan-name">${plan.name}</div>
                        <div class="plan-description">${getDescriptionByPlan(plan.name)}</div>
                    </div>
                    <div class="plan-pricing">
                        <div class="plan-price">
                            <span class="currency">$</span>${price}
                        </div>
                        <div class="plan-period">per month</div>
                    </div>
                    <ul class="plan-features">
                        ${featuresHtml}
                    </ul>
                    <button class="${buttonClass}" ${buttonAction} ${isCurrent ? 'disabled' : ''}>
                        ${buttonText}
                    </button>
                </div>
            `;
        });

        plansHtml += '</div>';
        plansContainer.innerHTML = plansHtml;
    }

    // Update billing section
    function updateBillingSection(data) {
        const billingSection = document.getElementById('billing-section');
        
        if (data.has_active_subscription && data.portal_url) {
            window.portalUrl = data.portal_url;
            billingSection.style.display = 'block';
        } else {
            billingSection.style.display = 'none';
        }
    }

    // Helper functions
    function formatPrice(amountInCents, currency) {
        const amount = amountInCents / 100;
        return amount.toFixed(2);
    }

    function getDescriptionByPlan(planName) {
        const descriptions = {
            'freemium': 'Perfect for individuals and small teams getting started',
            'pro': 'Comprehensive AI assistance for your business',
            'enterprise': 'Advanced features for large organizations'
        };
        return descriptions[planName.toLowerCase()] || 'Comprehensive AI assistance for your business';
    }

    function redirectToCheckout(checkoutUrl) {
        window.open(checkoutUrl, '_blank');
    }

    function activateFreemiumPlan(checkoutUrl) {
        if (checkoutUrl) {
            // If there's a checkout URL for freemium (for activation tracking), use it
            window.open(checkoutUrl, '_blank');
        } else {
            // Direct activation - refresh the page to show freemium as active
            if (confirm('Activate the free Freemium plan? This will give you access to basic features at no cost.')) {
                // Simulate activation by reloading plans
                loadPlans();
                alert('Freemium plan activated successfully! You now have access to basic features.');
            }
        }
    }

    function upgradePlan(planId, planName) {
        if (confirm(`Are you sure you want to upgrade to ${planName}?`)) {
            alert(`Redirecting to payment for ${planName} plan...\n\nPlan ID: ${planId}`);
        }
    }

    function openBillingPortal() {
        if (!window.portalUrl) {
            alert('Billing portal is not available');
            return;
        }
        window.open(window.portalUrl, '_blank');
    }

    function showError(message) {
        const errorHtml = `
            <div style="text-align: center; padding: 60px 40px; color: #ef4444;">
                <i class="fa fa-exclamation-triangle" style="font-size: 48px; margin-bottom: 20px; opacity: 0.5;"></i>
                <h3 style="margin: 0 0 12px 0; font-size: 20px; color: #111827;">Oops! Something went wrong</h3>
                <p style="margin: 0 0 24px 0; color: #6b7280;">${message}</p>
                <button onclick="loadPlans()" style="background: #6366f1; color: white; border: none; padding: 12px 24px; border-radius: 12px; font-weight: 600; cursor: pointer;">
                    <i class="fa fa-refresh"></i> Try Again
                </button>
            </div>
        `;

        document.getElementById('subscription-overview').innerHTML = errorHtml;
        document.getElementById('plans-container').innerHTML = errorHtml;
    }
</script>