<?php

/**
 * Dedicated file to support the SaaS module by Ulutfa
 */

defined('BASEPATH') or exit('No direct script access allowed');

defined('TOUR_GUIDE_MODULE_NAME') or define('TOUR_GUIDE_MODULE_NAME', 'tour_guide');

/**
 * We aimed that the super admin will share the tours with the tenant 
 * using a widget code from this module. We want to automatically provide the 
 * user information in the snippet code .
 * 
 * This will allow user to copy widget code from tour guide module and paste directly 
 * in saas > settings > custom code (tab) without any worries of providing user tag values.
 */
hooks()->add_filter('perfex_saas_global_custom_js_css_html', function ($html, $contexts) {

    static $replace_from = null;
    static $replace_to   = null;

    if ($replace_from === null) {

        $CI = &get_instance();
        $CI->load->helper(TOUR_GUIDE_MODULE_NAME . '/' . TOUR_GUIDE_MODULE_NAME);

        $u = tourGuideHelper()->activeUser(false);

        $replace_from = [
            '{USER_ID}',
            '{USER_EMAIL}',
            '{USER_FIRST_NAME}',
            '{USER_LAST_NAME}',
            '{USER_ROLE}',
            '{USER_LOCALE}',
        ];

        $replace_to = [
            $u['id'],
            $u['email'],
            $u['first_name'],
            $u['last_name'],
            $u['role'],
            $u['locale'],
        ];
    }

    return str_replace($replace_from, $replace_to, $html);
}, 10, 2);