<?php

namespace TourGuide\Http\Controllers;

use TourGuide\Widgets\TourGuideWidgetAPI;

/**
 * TourGuideWidgetCommonControllerTrait
 *
 * A wrapper trait class around the TourGuideWidgetAPI to Handles public widget API endpoints.
 */
trait TourGuideWidgetCommonControllerTrait
{
    /**
     * Central method for handling widget requests.
     *
     * @param string $action Action to perform (js, analytics, config).
     * @param string $widgetId Widget identifier (required for js and config actions).
     * @return void
     */
    public function widget($action = '', $widgetId = '')
    {
        if (empty($action)) {
            return;
        }

        switch ($action) {
            case 'js':
                TourGuideWidgetAPI::handleRequest('widget', ['widget_id' => $widgetId]);
                break;
            case 'analytics':
                TourGuideWidgetAPI::handleRequest('analytics');
                break;
            case 'config':
                TourGuideWidgetAPI::handleRequest('config', ['widget_id' => $widgetId]);
                break;
            default:
                return;
        }
    }
}
