<?php

namespace TourGuide\Http;

use TourGuide\TourGuideUtils;

trait TourGuideRouterTrait
{
    /**
     * Main function to route requests based on the "route" URL parameters.
     * Authorization is done using checks for capability
     * 
     * @since 1.0.0
     * @access public
     * @return mixed The output of the respective method for the specified route.
     */
    public function tourGuideRouteHandler($routePath = '')
    {
        // Sanitize and validate route path
        if (empty($routePath))
            $routePath = $_GET['route'] ?? '';

        $segments = explode('/', trim($routePath, '/'));

        $route = $segments[0];

        $allowedRoutes = ['user', 'index', 'delete', 'clone', 'form', 'translate', 'setup'];
        if ($this->allowedRoutes && is_array($this->allowedRoutes))
            $allowedRoutes = $this->allowedRoutes;

        if (!$this->staffCan('edit')) {

            $allowedRoutes = ['user']; // Allow submit endpoint and setup
            if (!empty(tourGuideHelper()->getSetupSessionId()))
                $allowedRoutes[] = 'setup';
        }

        if (empty($route)  || !in_array($route, $allowedRoutes) || !method_exists($this, $route))
            $route = 'index';

        // Prepare arguments for the controller method
        $args = $this->prepareArguments($route, $segments);

        // Call the validated and whitelisted controller method with sanitized arguments
        return $this->{$route}(...$args);
    }

    /**
     * Prepare sanitized arguments for the controller method.
     *
     * @param string $route The route to handle.
     * @param array $segments URL path segments.
     * @return array The array of sanitized arguments.
     * @since 1.0.0
     * @access private
     */
    private function prepareArguments($route, $segments)
    {
        $args = [];

        if (isset($segments[1])) {
            // First argument will always be the tour guide id except for 'user' method
            $args[] = $route === 'user' ? TourGuideUtils::escapeHtml($segments[1]) : (int)$segments[1];
        }

        if (isset($segments[2])) {
            // For setup endpoint only with either stop, start, save
            $segment2 = TourGuideUtils::escapeHtml(substr($segments[2], 0, 10));
            $segment2 = preg_replace('/[^a-zA-Z0-9]+/', '', $segment2);
            $args[] = $segment2;
        }

        return $args;
    }
}