<?php defined('TOUR_GUIDE_DIR') or exit('No direct script access allowed'); ?>

<?php if (!isset($config['load_as_fragment'])) : ?>
<script>
"use strict";
<?php endif; ?>
const TOUR_GUIDE_TOURS_RAW = JSON.parse(atob("<?php echo base64_encode(json_encode($tour_guides)); ?>"));
const TOUR_GUIDE_USER_URL = TOUR_GUIDE_CONFIG?.userAjaxUrl || "<?php echo tourGuideHelper()->userUrl(); ?>";
const TOUR_GUIDE_APP_BASE_URL = TOUR_GUIDE_CONFIG?.baseUrl || "<?php echo tourGuideHelper()->baseUrl(); ?>";

const TOUR_GUIDE_TOURS = {}
const TOUR_GUIDE_ACTIVE_TOURS = {};
const TOUR_GUIDE_TOURS_STEPS = {};
const TOUR_GUIDE_DEFAULT_EMPTY_SELECTOR = "body";

// Parse and prepare tour various format
for (const key in TOUR_GUIDE_TOURS_RAW) {

    try {
        const tour = TOUR_GUIDE_TOURS_RAW[key];
        TOUR_GUIDE_TOURS[key] = tour;
        TOUR_GUIDE_TOURS_STEPS[key] = tour.steps;

        if (tour.status == 'active') {
            TOUR_GUIDE_ACTIVE_TOURS[key] = tour;
        }
    } catch (error) {
        console.warn({
            key,
            error
        });
    }
}

// Contextual informations
const TOUR_GUIDE_USER_INFO =
    <?php echo json_encode(isset($config['active_user']) ? $config['active_user'] : tourGuideHelper()->activeUser()); ?>;
window.TOUR_GUIDE_USER_INFO = TOUR_GUIDE_USER_INFO;

const TOUR_GUIDE_SYSTEM_LOCALE =
    "<?php echo isset($config['locale']) ? $config['locale'] : tourGuideHelper()->systemLocale(); ?>"; //The default language inwhich the tour step is created i.e 'en'

const TOUR_GUIDE_STYLES_CLASSES = {
    primary_btn_class: "btn btn-primary",
    secondary_btn_class: "btn btn-info",
    accent_btn_class: "btn btn-danger",
    small_btn_class: "btn-sm",
    extra_small_btn_class: "btn-xs",
    ...TOUR_GUIDE_CONFIG?.stylesClasses || {}
};

let TOUR_GUIDE_TRANSLATIONS_MAP = {
    nextLabel: "<?php echo tourGuideHelper()->translate('tour_guide_next'); ?>", // text for next button
    prevLabel: "<?php echo tourGuideHelper()->translate('tour_guide_prev'); ?>", // text for prev button
    finishLabel: "<?php echo tourGuideHelper()->translate('tour_guide_finish'); ?>", // text for finish button

    // User available tour widget
    tour_guide_user_widget_close: "<?php echo tourGuideHelper()->translate('tour_guide_user_widget_close'); ?>",
    tour_guide_user_widget_open: "<?php echo tourGuideHelper()->translate('tour_guide_user_widget_open'); ?>",
    tour_guide_user_widget_one_tour_available: "<?php echo tourGuideHelper()->translate('tour_guide_user_widget_one_tour_available'); ?>",
    tour_guide_user_widget_multiple_tours_available: "<?php echo tourGuideHelper()->translate('tour_guide_user_widget_multiple_tours_available'); ?>",
    tour_guide_user_widget_no_tours_available: "<?php echo tourGuideHelper()->translate('tour_guide_user_widget_no_tours_available'); ?>",
    tour_guide_user_widget_start: "<i class='tour-guide-icon  tour-guide-icon-play-circle' data-toggle='tooltip' title='<?php echo tourGuideHelper()->translate('tour_guide_user_widget_start'); ?>'></i>",
    tour_guide_user_widget_toggle_open: "<?php echo tourGuideHelper()->translate('tour_guide_user_widget_toggle_open'); ?>",
    tour_guide_user_widget_toggle_close: "<?php echo tourGuideHelper()->translate('tour_guide_user_widget_toggle_close'); ?>",
};

<?php if (!isset($config['context']) || (isset($config['context']) && $config['context'] === "setup")) : ?>
const TOUR_GUIDE_ADMIN_URL = TOUR_GUIDE_CONFIG?.adminAjaxUrl || "<?php echo tourGuideHelper()->adminUrl(); ?>";
const TOUR_GUIDE_USER_ROLES = <?php echo json_encode(tourGuideHelper()->userRoles()); ?>;

TOUR_GUIDE_TRANSLATIONS_MAP = {
    ...TOUR_GUIDE_TRANSLATIONS_MAP,
    // Others
    play: "<?php echo tourGuideHelper()->translate('tour_guide_play'); ?>",
    edit: "<?php echo tourGuideHelper()->translate('tour_guide_edit'); ?>",
    delete: "<?php echo tourGuideHelper()->translate('tour_guide_delete'); ?>",
    selector: "<?php echo tourGuideHelper()->translate('tour_guide_selector'); ?>",
    replace: "<?php echo tourGuideHelper()->translate('tour_guide_replace'); ?>",
    tags: "<?php echo tourGuideHelper()->translate('tour_guide_tags'); ?>",
    tagsHint: "<?php echo tourGuideHelper()->translate('tour_guide_tags_hint'); ?>",

    // Quilljs Image plugin
    editor: "<?php echo tourGuideHelper()->translate('tour_guide_editor'); ?>",
    imageURL: "<?php echo tourGuideHelper()->translate('tour_guide_image_url'); ?>",
    altText: "<?php echo tourGuideHelper()->translate('tour_guide_alt_text'); ?>",
    imageWidth: "<?php echo tourGuideHelper()->translate('tour_guide_image_width'); ?>",
    imageHeight: "<?php echo tourGuideHelper()->translate('tour_guide_image_height'); ?>",

    // Translation form
    allDone: "<?php echo tourGuideHelper()->translate('tour_guide_translator_all_done'); ?>",
    done: "<?php echo tourGuideHelper()->translate('tour_guide_translator_done'); ?>",
    error: "<?php echo tourGuideHelper()->translate('tour_guide_translator_error'); ?>",
    translating: "<?php echo tourGuideHelper()->translate('tour_guide_translator_translating'); ?>",

    // Tour gudie create form
    tour_guide_triggers: "<?php echo tourGuideHelper()->translate('tour_guide_triggers'); ?>",
    tour_guide_add_trigger: "<?php echo tourGuideHelper()->translate('tour_guide_add_trigger'); ?>",
    tour_guide_trigger_id: "<?php echo tourGuideHelper()->translate('tour_guide_trigger_id'); ?>",
    tour_guide_remove: "<?php echo tourGuideHelper()->translate('tour_guide_remove'); ?>",
    tour_guide_and: "<?php echo tourGuideHelper()->translate('tour_guide_and'); ?>",
    tour_guide_or: "<?php echo tourGuideHelper()->translate('tour_guide_or'); ?>",
    tour_guide_add_rule: "<?php echo tourGuideHelper()->translate('tour_guide_add_rule'); ?>",
    tour_guide_select_field: "<?php echo tourGuideHelper()->translate('tour_guide_select_field'); ?>",
    tour_guide_url: "<?php echo tourGuideHelper()->translate('tour_guide_url'); ?>",
    tour_guide_path: "<?php echo tourGuideHelper()->translate('tour_guide_path'); ?>",
    tour_guide_select_operator: "<?php echo tourGuideHelper()->translate('tour_guide_select_operator'); ?>",
    tour_guide_equals: "<?php echo tourGuideHelper()->translate('tour_guide_equals'); ?>",
    tour_guide_not_equals: "<?php echo tourGuideHelper()->translate('tour_guide_not_equals'); ?>",
    tour_guide_contains: "<?php echo tourGuideHelper()->translate('tour_guide_contains'); ?>",
    tour_guide_does_not_contain: "<?php echo tourGuideHelper()->translate('tour_guide_does_not_contain'); ?>",
    tour_guide_starts_with: "<?php echo tourGuideHelper()->translate('tour_guide_starts_with'); ?>",
    tour_guide_not_starts_with: "<?php echo tourGuideHelper()->translate('tour_guide_not_starts_with'); ?>",
    tour_guide_ends_with: "<?php echo tourGuideHelper()->translate('tour_guide_ends_with'); ?>",
    tour_guide_not_ends_with: "<?php echo tourGuideHelper()->translate('tour_guide_not_ends_with'); ?>",
    tour_guide_greater_than: "<?php echo tourGuideHelper()->translate('tour_guide_greater_than'); ?>",
    tour_guide_less_than: "<?php echo tourGuideHelper()->translate('tour_guide_less_than'); ?>",
    tour_guide_greater_than_or_equals: "<?php echo tourGuideHelper()->translate('tour_guide_greater_than_or_equals'); ?>",
    tour_guide_less_than_or_equals: "<?php echo tourGuideHelper()->translate('tour_guide_less_than_or_equals'); ?>",
    tour_guide_matches_regex: "<?php echo tourGuideHelper()->translate('tour_guide_matches_regex'); ?>",
    tour_guide_is_empty: "<?php echo tourGuideHelper()->translate('tour_guide_is_empty'); ?>",
    tour_guide_is_not_empty: "<?php echo tourGuideHelper()->translate('tour_guide_is_not_empty'); ?>",
    tour_guide_value_placeholder: "<?php echo tourGuideHelper()->translate('tour_guide_value_placeholder'); ?>",

    // Tour guide triggers form
    tour_guide_referrer: "<?php echo tourGuideHelper()->translate('tour_guide_referrer'); ?>",
    tour_guide_browser: "<?php echo tourGuideHelper()->translate('tour_guide_browser'); ?>",
    tour_guide_device: "<?php echo tourGuideHelper()->translate('tour_guide_device'); ?>",
    tour_guide_os: "<?php echo tourGuideHelper()->translate('tour_guide_os'); ?>",
    tour_guide_time_on_page: "<?php echo tourGuideHelper()->translate('tour_guide_time_on_page'); ?>",
    tour_guide_number_of_visits: "<?php echo tourGuideHelper()->translate('tour_guide_number_of_visits'); ?>",
    tour_guide_language: "<?php echo tourGuideHelper()->translate('tour_guide_language'); ?>",
    tour_guide_screen_width: "<?php echo tourGuideHelper()->translate('tour_guide_screen_width'); ?>",
    tour_guide_screen_height: "<?php echo tourGuideHelper()->translate('tour_guide_screen_height'); ?>",
    tour_guide_scroll_position: "<?php echo tourGuideHelper()->translate('tour_guide_scroll_position'); ?>",
    tour_guide_user_role: "<?php echo tourGuideHelper()->translate('tour_guide_user_role'); ?>",
    tour_guide_finished_tours: "<?php echo tourGuideHelper()->translate('tour_guide_finished_tours'); ?>",
};
<?php endif; ?>
<?php if (!isset($config['load_as_fragment'])) : ?>
</script>
<?php endif; ?>

<?php
if (!isset($config['custom_asset_loading'])) :
    $versionTag = '?v=' . TOUR_GUIDE_CORE_VERSION;
?>
<link id="tour-guide-core-css" rel="stylesheet" type="text/css"
    href="<?php echo tourGuideHelper()->asset('tour-guide.min.css'); ?><?= $versionTag; ?>">
<script id="tour-guide-core-js" type="module"
    src="<?php echo tourGuideHelper()->asset('tour-guide.min.js'); ?><?= $versionTag; ?>">
</script>
<?php endif; ?>