<?php defined('TOUR_GUIDE_DIR') or exit('No direct script access allowed'); ?>

<div class="tour-guide-content-wrapper tour-guide-translations" data-tour-guide-translator="true"
    data-tour-guide-translator-default-lang="<?php echo $default_language; ?>">
    <div class="tour-guide-flex">
        <div class="language-selector">
            <label
                for="language-select"><?php echo tourGuideHelper()->translate('tour_guide_select_language'); ?>:</label>
            <div class="row">
                <div class="col-md-6">
                    <select id="tour-guide-language-select" class="form-control">
                        <?php foreach ($supported_languages as $language) : ?>
                        <option value="<?php echo tourGuideHelper()->encode($language[$lang_compare_index]); ?>"
                            <?php echo strtolower($language[$lang_compare_index]) == $default_language ? 'selected' : ''; ?>>
                            <?php echo tourGuideHelper()->encode($language['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <button type="button" class="btn btn-primary auto-translate-btn"
                        data-languages="all"><?php echo tourGuideHelper()->translate('tour_guide_auto_translate_all'); ?></button>

                    <button type="button" class="btn btn-primary auto-translate-btn"
                        data-languages="current"><?php echo tourGuideHelper()->translate('tour_guide_auto_translate_selected'); ?></button>
                    <button type="button" class="btn btn-danger stop-auto-translate-btn hidden"
                        data-languages="current"><?php echo tourGuideHelper()->translate('tour_guide_stop_auto_translate'); ?></button>
                </div>
            </div>
        </div>

    </div>
    <div class="translation-progress" style="display:none;">
        <div>
            <hr />
        </div>
        <p id="translation-status"></p>
        <progress id="progress-bar" value="0" max="100"></progress>
    </div>

    <div>
        <hr />
    </div>

    <?php foreach ($supported_languages as $language) : $language_id = strtolower($language[$lang_compare_index]); ?>
    <div class="steps-container <?php echo $language_id == $default_language ? '' : 'hidden'; ?>"
        data-steps-lang="<?php echo $language[$lang_compare_index]; ?>">
        <!-- Step translations will be here as in previous example -->
        <?php
            $index = 0;
            foreach ($steps as $step) :
                $step = (object)$step;
                $stepUid =  $step->uid;
                $stepTitle = $steps_translations[$language_id][$stepUid]['title'] ?? $step->title;
                $stepDescription = $steps_translations[$language_id][$stepUid]['description'] ?? $step->description;
                $index++;
            ?>
        <div class="tour-guide-step-translation" data-step-uid="<?php echo $stepUid; ?>">
            <div class="h4 tour-guide-step-translation-step-divider">
                <span><?php echo tourGuideHelper()->translate('tour_guide_step'); ?></span> <?php echo $index; ?>.
            </div>
            <div class="form-group">
                <label
                    for="tour-step-title-<?php echo $stepUid; ?>"><?php echo tourGuideHelper()->translate('tour_guide_step_title'); ?></label>
                <input type="text"
                    name="steps_translations[<?php echo $language_id; ?>][<?php echo $stepUid; ?>][title]"
                    class="form-control" id="tour-step-title-<?php echo $stepUid; ?>"
                    placeholder="<?php echo tourGuideHelper()->translate('tour_guide_step_title_placeholder'); ?>"
                    data-toggle="tooltip" title="<?php echo tourGuideHelper()->translate('tour_guide_step_title'); ?>"
                    value="<?php echo $stepTitle; ?>">
            </div>
            <div class="form-group">
                <label
                    for="tour-step-desc-<?php echo $stepUid; ?>"><?php echo tourGuideHelper()->translate('tour_guide_step_description'); ?></label>
                <textarea name="steps_translations[<?php echo $language_id; ?>][<?php echo $stepUid; ?>][description]"
                    class="form-control" id="tour-step-desc-<?php echo $stepUid; ?>"
                    placeholder="<?php echo tourGuideHelper()->translate('tour_guide_step_description_placeholder'); ?>"
                    data-toggle="tooltip"
                    title="<?php echo tourGuideHelper()->translate('tour_guide_step_description'); ?>"><?php echo $stepDescription; ?></textarea>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php endforeach; ?>
</div>