<!-- Embed Code Modal -->
<div class="modal fade" id="embedCodeModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?= tourGuideHelper()->translate('tour_guide_widget_embed_code') ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="tour-guide-embed-options">
                    <!-- Option 1: Direct Script Tag -->
                    <div class="tour-guide-embed-option">
                        <h6 class="mb-2"><?= tourGuideHelper()->translate('tour_guide_embed_option_script') ?></h6>
                        <p class="text-muted small">
                            <?= tourGuideHelper()->translate('tour_guide_embed_option_script_desc') ?></p>
                        <textarea class="form-control" id="embedCodeScript" rows="2" readonly></textarea>
                        <button type="button" class="btn btn-sm btn-outline-secondary mt-2"
                            onclick="copyEmbedCode('script')">
                            <?= tourGuideHelper()->translate('tour_guide_copy_to_clipboard') ?>
                        </button>
                    </div>

                    <!-- Option 2: JavaScript Dynamic Loading -->
                    <div class="tour-guide-embed-option">
                        <h6 class="mb-2"><?= tourGuideHelper()->translate('tour_guide_embed_option_js') ?></h6>
                        <p class="text-muted small">
                            <?= tourGuideHelper()->translate('tour_guide_embed_option_js_desc') ?></p>
                        <textarea class="form-control" id="embedCodeJS" rows="6" readonly></textarea>
                        <button type="button" class="btn btn-sm btn-outline-secondary mt-2"
                            onclick="copyEmbedCode('js')">
                            <?= tourGuideHelper()->translate('tour_guide_copy_to_clipboard') ?>
                        </button>
                    </div>

                    <!-- User Parameters Option -->
                    <div class="tour-guide-embed-option">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="includeUserParams"
                                onchange="updateEmbedCodes()">
                            <label class="form-check-label" for="includeUserParams">
                                <strong><?= tourGuideHelper()->translate('tour_guide_include_user_params') ?></strong>
                            </label>
                        </div>
                        <p class="text-muted small mt-2">
                            <?= tourGuideHelper()->translate('tour_guide_include_user_params_desc') ?>
                        </p>

                        <!-- User Parameters Documentation -->
                        <div class="mt-3" id="userParamsHelp" style="display: none;">
                            <h6 class="mb-2"><?= tourGuideHelper()->translate('tour_guide_user_parameters') ?></h6>
                            <div class="table-responsive">
                                <table class="table table-sm table-borderless">
                                    <tbody>
                                        <tr>
                                            <td class="text-monospace">user_id</td>
                                            <td><?= tourGuideHelper()->translate('tour_guide_param_user_id') ?></td>
                                        </tr>
                                        <tr>
                                            <td class="text-monospace">user_email</td>
                                            <td><?= tourGuideHelper()->translate('tour_guide_param_user_email') ?></td>
                                        </tr>
                                        <tr>
                                            <td class="text-monospace">user_first_name</td>
                                            <td><?= tourGuideHelper()->translate('tour_guide_param_user_first_name') ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-monospace">user_last_name</td>
                                            <td><?= tourGuideHelper()->translate('tour_guide_param_user_last_name') ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-monospace">user_role</td>
                                            <td><?= tourGuideHelper()->translate('tour_guide_param_user_role', implode(',', tourGuideHelper()->userRoles())) ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-monospace">user_locale</td>
                                            <td><?= tourGuideHelper()->translate('tour_guide_param_user_locale') ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
var currentWidgetId = '';
var currentBaseUrl = '';

document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll(".tour-guide-show-embed").forEach(function(button) {
        button.addEventListener("click", function() {
            currentWidgetId = this.getAttribute("data-widget-id");
            currentBaseUrl = TOUR_GUIDE_USER_URL;

            // Reset checkbox
            document.getElementById("includeUserParams").checked = false;
            document.getElementById("userParamsHelp").style.display = "none";

            // Generate initial codes
            updateEmbedCodes();

            // Show modal
            if (typeof $ !== "undefined" && $.fn.modal) {
                $("#embedCodeModal").modal("show");
            } else if (typeof bootstrap !== "undefined") {
                new bootstrap.Modal(document.getElementById("embedCodeModal")).show();
            }
        });
    });
});

function updateEmbedCodes() {
    var includeUserParams = document.getElementById("includeUserParams").checked;
    var userParamsHelp = document.getElementById("userParamsHelp");

    // Show/hide user parameters help
    userParamsHelp.style.display = includeUserParams ? "block" : "none";

    var baseWidgetUrl = currentBaseUrl + "widget/js/" + currentWidgetId;
    var userParamsUrl = includeUserParams ?
        "?user_id={USER_ID}&user_email={USER_EMAIL}&user_first_name={USER_FIRST_NAME}&user_last_name={USER_LAST_NAME}&user_role={USER_ROLE}&user_locale={USER_LOCALE}" :
        "";

    // Option 1: Direct Script Tag
    var scriptCode = "<" + "script src=\"" + baseWidgetUrl + userParamsUrl + "\"><" + "/script>";

    // Option 2: JavaScript Dynamic Loading
    var jsCode;
    if (includeUserParams) {
        jsCode = `(function() {
    // Replace with your actual user data
    var userId = '{USER_ID}';
    var userEmail = '{USER_EMAIL}';
    var userFirstName = '{USER_FIRST_NAME}';
    var userLastName = '{USER_LAST_NAME}';
    var userRole = '{USER_ROLE}';
    var userLocale = '{USER_LOCALE}';
    
    var params = new URLSearchParams();
    if (userId) params.append('user_id', userId);
    if (userEmail) params.append('user_email', userEmail);
    if (userFirstName) params.append('user_first_name', userFirstName);
    if (userLastName) params.append('user_last_name', userLastName);
    if (userRole) params.append('user_role', userRole);
    if (userLocale) params.append('user_locale', userLocale);
    
    var script = document.createElement("script");
    script.src = "${baseWidgetUrl}" + (params.toString() ? "?" + params.toString() : "");
    document.head.appendChild(script);
})();`;
    } else {
        jsCode = `(function() {
    var script = document.createElement("script");
    script.src = "${baseWidgetUrl}";
    document.head.appendChild(script);
})();`;
    }

    // Set the codes
    document.getElementById("embedCodeScript").value = scriptCode;
    document.getElementById("embedCodeJS").value = jsCode;
}

function copyEmbedCode(type) {
    var targetId = "embedCodeScript"; // default

    switch (type) {
        case "script":
            targetId = "embedCodeScript";
            break;
        case "js":
            targetId = "embedCodeJS";
            break;
    }

    var element = document.getElementById(targetId);
    element.select();
    element.setSelectionRange(0, 99999);

    try {
        document.execCommand("copy");
        alert("<?= tourGuideHelper()->translate('tour_guide_copied_to_clipboard') ?>");
    } catch (err) {
        console.error("Could not copy text: ", err);
    }
}
</script>