<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">

                        <h4 class="tw-mt-0 tw-font-semibold tw-text-lg tw-text-neutral-700">
                            <?php echo $title; ?>
                        </h4>

                        <?php echo form_open(current_url(), ['class' => 'tour-guide-widget-form']); ?>

                        <?php
                        // Prepare data for the widget form
                        $form_action = current_url();
                        $back_url = tourGuideHelper()->adminUrl('widgets');
                        $show_form_actions = true;
                        $csrf_token = $this->security->get_csrf_hash();

                        // Include the core widget form view (dynamic rendering)
                        TourGuide\TourGuideUtils::renderView('widgets/form', [
                            'widget' => $widget ?? null,
                            'tours_list' => $tours_list ?? [],
                            'form_action' => $form_action,
                            'back_url' => $back_url,
                            'show_form_actions' => $show_form_actions,
                            'csrf_token' => $csrf_token
                        ]);
                        ?>

                        <?php echo form_close(); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>


<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle tour selection based on widget type
    var typeSelect = document.getElementById('widget_type');
    var tourSection = document.querySelector('.tour-selection-section');

    function toggleTourSelection() {
        if (typeSelect && tourSection) {
            var isSetupWidget = typeSelect.value === 'setup';
            tourSection.style.display = isSetupWidget ? 'none' : 'block';
        }
    }

    if (typeSelect) {
        typeSelect.addEventListener('change', toggleTourSelection);
        toggleTourSelection(); // Initial state
    }
});
</script>